process.env.HMR_PORT=0;process.env.HMR_HOSTNAME="localhost";// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"src/utils/devmode.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDevMode = void 0;
/**
 * Are we currently running in development mode?
 *
 * @returns {boolean}
 */

function isDevMode() {
  return !!process.defaultApp;
}

exports.isDevMode = isDevMode;
},{}],"src/main/about-panel.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAboutPanel = void 0;

const electron_1 = require("electron");
/**
 * Sets Fiddle's About panel options on Linux and macOS
 *
 * @returns
 */


function setupAboutPanel() {
  if (process.platform === "win32") return;
  const options = {
    applicationName: "windows95",
    applicationVersion: electron_1.app.getVersion(),
    version: process.versions.electron,
    copyright: "Felix Rieseberg"
  };

  switch (process.platform) {
    case "linux":
      options.website = "https://github.com/felixrieseberg/windows95";

    case "darwin":
      options.credits = "https://github.com/felixrieseberg/windows95";

    default: // fallthrough

  }

  electron_1.app.setAboutPanelOptions(options);
}

exports.setupAboutPanel = setupAboutPanel;
},{}],"src/main/squirrel.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldQuit = void 0;

function shouldQuit() {
  return require("electron-squirrel-startup");
}

exports.shouldQuit = shouldQuit;
},{}],"src/main/update.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupUpdates = void 0;

const electron_1 = require("electron");

function setupUpdates() {
  if (electron_1.app.isPackaged) {
    require("update-electron-app")({
      repo: "felixrieseberg/windows95",
      updateInterval: "1 hour"
    });
  }
}

exports.setupUpdates = setupUpdates;
},{}],"src/main/windows.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrCreateWindow = void 0;

const electron_1 = require("electron");

let mainWindow = null;

function getOrCreateWindow() {
  if (mainWindow) return mainWindow; // Create the browser window.

  mainWindow = new electron_1.BrowserWindow({
    width: 1024,
    height: 768,
    useContentSize: true,
    webPreferences: {
      nodeIntegration: true,
      sandbox: false,
      webviewTag: false,
      contextIsolation: false
    }
  }); // mainWindow.webContents.toggleDevTools();

  mainWindow.loadFile("./dist/static/index.html");
  mainWindow.webContents.on("will-navigate", (event, url) => handleNavigation(event, url));
  mainWindow.webContents.on("new-window", (event, url) => handleNavigation(event, url));
  mainWindow.on("closed", () => {
    mainWindow = null;
  });
  return mainWindow;
}

exports.getOrCreateWindow = getOrCreateWindow;

function handleNavigation(event, url) {
  if (url.startsWith("http")) {
    event.preventDefault();
    electron_1.shell.openExternal(url);
  }
}
},{}],"src/cache.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearStorageData = exports.clearCache = exports.clearCaches = void 0;

const electron_1 = require("electron");

async function clearCaches() {
  await clearCache();
  await clearStorageData();
}

exports.clearCaches = clearCaches;

async function clearCache() {
  if (electron_1.session.defaultSession) {
    await electron_1.session.defaultSession.clearCache();
  }
}

exports.clearCache = clearCache;

async function clearStorageData() {
  if (!electron_1.session.defaultSession) {
    return;
  }

  await electron_1.session.defaultSession.clearStorageData({
    storages: ["appcache", "cookies", "filesystem", "indexdb", "localstorage", "shadercache", "websql", "serviceworkers"],
    quotas: ["temporary", "persistent", "syncable"]
  });
}

exports.clearStorageData = clearStorageData;
},{}],"src/constants.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IPC_COMMANDS = exports.CONSTANTS = void 0;

const tslib_1 = require("tslib");

const path = tslib_1.__importStar(require("path"));

exports.CONSTANTS = {
  IMAGE_PATH: path.join(__dirname, "../../images/windows95.img"),
  IMAGE_DEFAULT_SIZE: 1073741824,
  DEFAULT_STATE_PATH: path.join(__dirname, "../../images/default-state.bin")
};
exports.IPC_COMMANDS = {
  TOGGLE_INFO: "TOGGLE_INFO",
  SHOW_DISK_IMAGE: "SHOW_DISK_IMAGE",
  ZOOM_IN: "ZOOM_IN",
  ZOOM_OUT: "ZOOM_OUT",
  ZOOM_RESET: "ZOOM_RESET",
  // Machine instructions
  MACHINE_START: "MACHINE_START",
  MACHINE_RESTART: "MACHINE_RESTART",
  MACHINE_STOP: "MACHINE_STOP",
  MACHINE_RESET: "MACHINE_RESET",
  MACHINE_ALT_F4: "MACHINE_ALT_F4",
  MACHINE_ESC: "MACHINE_ESC",
  MACHINE_ALT_ENTER: "MACHINE_ALT_ENTER",
  MACHINE_CTRL_ALT_DEL: "MACHINE_CTRL_ALT_DEL",
  // Machine events
  MACHINE_STARTED: "MACHINE_STARTED",
  MACHINE_STOPPED: "MACHINE_STOPPED",
  // Else
  APP_QUIT: "APP_QUIT",
  GET_STATE_PATH: "GET_STATE_PATH"
};
},{}],"src/main/menu.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMenu = void 0;

const electron_1 = require("electron");

const cache_1 = require("../cache");

const constants_1 = require("../constants");

const devmode_1 = require("../utils/devmode");

const LINKS = {
  homepage: "https://www.twitter.com/felixrieseberg",
  repo: "https://github.com/felixrieseberg/windows95",
  credits: "https://github.com/felixrieseberg/windows95/blob/master/CREDITS.md",
  help: "https://github.com/felixrieseberg/windows95/blob/master/HELP.md"
};

async function setupMenu() {
  await createMenu();
  electron_1.ipcMain.on(constants_1.IPC_COMMANDS.MACHINE_STARTED, () => createMenu({
    isRunning: true
  }));
  electron_1.ipcMain.on(constants_1.IPC_COMMANDS.MACHINE_STOPPED, () => createMenu({
    isRunning: false
  }));
}

exports.setupMenu = setupMenu;

function send(cmd) {
  const windows = electron_1.BrowserWindow.getAllWindows();

  if (windows[0]) {
    console.log(`Sending "${cmd}"`);
    windows[0].webContents.send(cmd);
  } else {
    console.log(`Tried to send "${cmd}", but could not find window`);
  }
}

async function createMenu({
  isRunning
} = {
  isRunning: false
}) {
  const template = [{
    label: "View",
    submenu: [{
      label: "Toggle Full Screen",
      accelerator: function () {
        if (process.platform === "darwin") {
          return "Ctrl+Command+F";
        } else {
          return "F11";
        }
      }(),
      click: function (_item, focusedWindow) {
        if (focusedWindow) {
          focusedWindow.setFullScreen(!focusedWindow.isFullScreen());
        }
      }
    }, {
      label: "Toggle Developer Tools",
      accelerator: function () {
        if (process.platform === "darwin") {
          return "Alt+Command+I";
        } else {
          return "Ctrl+Shift+I";
        }
      }(),
      click: function (_item, focusedWindow) {
        if (focusedWindow) {
          focusedWindow.webContents.toggleDevTools();
        }
      }
    }, {
      type: "separator"
    }, {
      label: "Toggle Emulator Info",
      click: () => send(constants_1.IPC_COMMANDS.TOGGLE_INFO)
    }, {
      type: "separator"
    }, {
      role: "reload"
    }]
  }, {
    role: "editMenu",
    visible: (0, devmode_1.isDevMode)()
  }, {
    label: "Window",
    role: "window",
    submenu: [{
      label: "Minimize",
      accelerator: "CmdOrCtrl+M",
      role: "minimize"
    }, {
      label: "Close",
      accelerator: "CmdOrCtrl+W",
      role: "close"
    }, {
      type: "separator"
    }, {
      label: "Zoom in",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_IN),
      enabled: isRunning
    }, {
      label: "Zoom out",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_OUT),
      enabled: isRunning
    }, {
      label: "Reset zoom",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_RESET),
      enabled: isRunning
    }]
  }, {
    label: "Machine",
    submenu: [{
      label: "Send Ctrl+Alt+Del",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_CTRL_ALT_DEL),
      enabled: isRunning
    }, {
      label: "Send Alt+F4",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ALT_F4),
      enabled: isRunning
    }, {
      label: "Send Alt+Enter",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ALT_ENTER),
      enabled: isRunning
    }, {
      label: "Send Esc",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ESC),
      enabled: isRunning
    }, {
      type: "separator"
    }, isRunning ? {
      label: "Stop",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_STOP)
    } : {
      label: "Start",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_START)
    }, {
      label: "Restart",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_RESTART),
      enabled: isRunning
    }, {
      label: "Reset",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_RESET),
      enabled: isRunning
    }, {
      type: "separator"
    }, {
      label: "Go to Disk Image",
      click: () => send(constants_1.IPC_COMMANDS.SHOW_DISK_IMAGE)
    }]
  }, {
    label: "Help",
    role: "help",
    submenu: [{
      label: "Author",
      click: () => electron_1.shell.openExternal(LINKS.homepage)
    }, {
      label: "windows95 on GitHub",
      click: () => electron_1.shell.openExternal(LINKS.repo)
    }, {
      label: "Help",
      click: () => electron_1.shell.openExternal(LINKS.help)
    }, {
      type: "separator"
    }, {
      label: "Troubleshooting",
      submenu: [{
        label: "Clear Cache and Restart",

        async click() {
          await (0, cache_1.clearCaches)();
          electron_1.app.relaunch();
          electron_1.app.quit();
        }

      }]
    }]
  }];

  if (process.platform === "darwin") {
    template.unshift({
      label: "windows95",
      submenu: [{
        role: "about"
      }, {
        type: "separator"
      }, {
        role: "services"
      }, {
        type: "separator"
      }, {
        label: "Hide windows95",
        accelerator: "Command+H",
        role: "hide"
      }, {
        label: "Hide Others",
        accelerator: "Command+Shift+H",
        role: "hideothers"
      }, {
        role: "unhide"
      }, {
        type: "separator"
      }, {
        label: "Quit",
        accelerator: "Command+Q",

        click() {
          electron_1.app.quit();
        }

      }]
    });
  }

  electron_1.Menu.setApplicationMenu(electron_1.Menu.buildFromTemplate(template));
}
},{"../cache":"src/cache.ts","../constants":"src/constants.ts","../utils/devmode":"src/utils/devmode.ts"}],"src/main/ipc.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupIpcListeners = void 0;

const tslib_1 = require("tslib");

const electron_1 = require("electron");

const path = tslib_1.__importStar(require("path"));

const constants_1 = require("../constants");

function setupIpcListeners() {
  electron_1.ipcMain.handle(constants_1.IPC_COMMANDS.GET_STATE_PATH, () => {
    return path.join(electron_1.app.getPath("userData"), "state-v3.bin");
  });
  electron_1.ipcMain.handle(constants_1.IPC_COMMANDS.APP_QUIT, () => {
    electron_1.app.quit();
  });
}

exports.setupIpcListeners = setupIpcListeners;
},{"../constants":"src/constants.ts"}],"src/main/main.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.main = exports.onWindowsAllClosed = exports.onBeforeQuit = exports.onReady = void 0;

const electron_1 = require("electron");

const devmode_1 = require("../utils/devmode");

const about_panel_1 = require("./about-panel");

const squirrel_1 = require("./squirrel");

const update_1 = require("./update");

const windows_1 = require("./windows");

const menu_1 = require("./menu");

const ipc_1 = require("./ipc");
/**
 * Handle the app's "ready" event. This is essentially
 * the method that takes care of booting the application.
 */


async function onReady() {
  if (!(0, devmode_1.isDevMode)()) process.env.NODE_ENV = "production";
  (0, ipc_1.setupIpcListeners)();
  (0, windows_1.getOrCreateWindow)();
  (0, about_panel_1.setupAboutPanel)();
  (0, menu_1.setupMenu)();
  (0, update_1.setupUpdates)();
}

exports.onReady = onReady;
/**
 * Handle the "before-quit" event
 *
 * @export
 */

function onBeforeQuit() {
  global.isQuitting = true;
}

exports.onBeforeQuit = onBeforeQuit;
/**
 * All windows have been closed, quit on anything but
 * macOS.
 */

function onWindowsAllClosed() {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== "darwin") {
    electron_1.app.quit();
  }
}

exports.onWindowsAllClosed = onWindowsAllClosed;
/**
 * The main method - and the first function to run
 * when Fiddle is launched.
 *
 * Exported for testing purposes.
 */

function main() {
  // Handle creating/removing shortcuts on Windows when
  // installing/uninstalling.
  if ((0, squirrel_1.shouldQuit)()) {
    electron_1.app.quit();
    return;
  } // Set the app's name


  electron_1.app.setName("windows95"); // Launch

  electron_1.app.on("ready", onReady);
  electron_1.app.on("before-quit", onBeforeQuit);
  electron_1.app.on("window-all-closed", onWindowsAllClosed);
}

exports.main = main;
main();
},{"../utils/devmode":"src/utils/devmode.ts","./about-panel":"src/main/about-panel.ts","./squirrel":"src/main/squirrel.ts","./update":"src/main/update.ts","./windows":"src/main/windows.ts","./menu":"src/main/menu.ts","./ipc":"src/main/ipc.ts"}]},{},["src/main/main.ts"], null)
//# sourceMappingURL=../src/main/main.js.map