process.env.HMR_PORT=0;process.env.HMR_HOSTNAME="localhost";// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"src/constants.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IPC_COMMANDS = exports.CONSTANTS = void 0;

const tslib_1 = require("tslib");

const path = tslib_1.__importStar(require("path"));

exports.CONSTANTS = {
  IMAGE_PATH: path.join(__dirname, "../../images/windows95.img"),
  IMAGE_DEFAULT_SIZE: 1073741824,
  DEFAULT_STATE_PATH: path.join(__dirname, "../../images/default-state.bin")
};
exports.IPC_COMMANDS = {
  TOGGLE_INFO: "TOGGLE_INFO",
  SHOW_DISK_IMAGE: "SHOW_DISK_IMAGE",
  ZOOM_IN: "ZOOM_IN",
  ZOOM_OUT: "ZOOM_OUT",
  ZOOM_RESET: "ZOOM_RESET",
  // Machine instructions
  MACHINE_START: "MACHINE_START",
  MACHINE_RESTART: "MACHINE_RESTART",
  MACHINE_STOP: "MACHINE_STOP",
  MACHINE_RESET: "MACHINE_RESET",
  MACHINE_ALT_F4: "MACHINE_ALT_F4",
  MACHINE_ESC: "MACHINE_ESC",
  MACHINE_ALT_ENTER: "MACHINE_ALT_ENTER",
  MACHINE_CTRL_ALT_DEL: "MACHINE_CTRL_ALT_DEL",
  // Machine events
  MACHINE_STARTED: "MACHINE_STARTED",
  MACHINE_STOPPED: "MACHINE_STOPPED",
  // Else
  APP_QUIT: "APP_QUIT",
  GET_STATE_PATH: "GET_STATE_PATH"
};
},{}],"src/utils/disk-image-size.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiskImageSize = void 0;

const tslib_1 = require("tslib");

const fs = tslib_1.__importStar(require("fs-extra"));

const constants_1 = require("../constants");
/**
 * Get the size of the disk image
 *
 * @returns {number}
 */


async function getDiskImageSize(path) {
  try {
    const stats = await fs.stat(path);

    if (stats) {
      return stats.size;
    }
  } catch (error) {
    console.warn(`Could not determine image size`, error);
  }

  return constants_1.CONSTANTS.IMAGE_DEFAULT_SIZE;
}

exports.getDiskImageSize = getDiskImageSize;
},{"../constants":"src/constants.ts"}],"src/renderer/card-start.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardStart = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

class CardStart extends React.Component {
  render() {
    return React.createElement("section", {
      id: "section-start"
    }, React.createElement("button", {
      className: "btn",
      id: "win95",
      onClick: this.props.startEmulator
    }, React.createElement("img", {
      src: "../../static/run.png"
    }), React.createElement("span", null, "Start Windows 95")), React.createElement("small", null, "Hit ESC to lock or unlock your mouse"));
  }

}

exports.CardStart = CardStart;
},{}],"src/renderer/start-menu.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartMenu = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

class StartMenu extends React.Component {
  constructor(props) {
    super(props);
    this.navigate = this.navigate.bind(this);
  }

  render() {
    return React.createElement("nav", {
      className: "nav nav-bottom"
    }, React.createElement("a", {
      onClick: this.navigate,
      href: "#",
      id: "start",
      className: "nav-link"
    }, React.createElement("img", {
      src: "../../static/start.png",
      alt: "Start"
    }), React.createElement("span", null, "Start")), React.createElement("div", {
      className: "nav-menu"
    }, React.createElement("a", {
      onClick: this.navigate,
      href: "#",
      id: "settings",
      className: "nav-link"
    }, React.createElement("img", {
      src: "../../static/settings.png"
    }), React.createElement("span", null, "Settings")), React.createElement("a", {
      onClick: this.navigate,
      href: "#",
      id: "drive",
      className: "nav-link"
    }, React.createElement("img", {
      src: "../../static/drive.png"
    }), React.createElement("span", null, "Modify C: Drive"))));
  }

  navigate(event) {
    this.props.navigate(event.currentTarget.id);
  }

}

exports.StartMenu = StartMenu;
},{}],"src/renderer/utils/get-state-path.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatePath = void 0;

const electron_1 = require("electron");

const constants_1 = require("../../constants");

let _statePath = "";

async function getStatePath() {
  if (_statePath) {
    return _statePath;
  }

  const statePath = await electron_1.ipcRenderer.invoke(constants_1.IPC_COMMANDS.GET_STATE_PATH);
  return _statePath = statePath;
}

exports.getStatePath = getStatePath;
},{"../../constants":"src/constants.ts"}],"src/renderer/card-settings.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardSettings = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

const fs = tslib_1.__importStar(require("fs-extra"));

const get_state_path_1 = require("./utils/get-state-path");

class CardSettings extends React.Component {
  constructor(props) {
    super(props);
    this.onChangeFloppy = this.onChangeFloppy.bind(this);
    this.onChangeCdrom = this.onChangeCdrom.bind(this);
    this.onResetState = this.onResetState.bind(this);
    this.state = {
      isStateReset: false
    };
  }

  render() {
    return React.createElement("section", null, React.createElement("div", {
      className: "card settings"
    }, React.createElement("div", {
      className: "card-header"
    }, React.createElement("h2", {
      className: "card-title"
    }, React.createElement("img", {
      src: "../../static/settings.png"
    }), "Settings")), React.createElement("div", {
      className: "card-body"
    }, this.renderCdrom(), React.createElement("hr", null), this.renderFloppy(), React.createElement("hr", null), this.renderState())));
  }

  renderCdrom() {
    // CD is currently not working, so.. let's return nothing.
    return null;
    const {
      cdrom
    } = this.props;
    return React.createElement("fieldset", null, React.createElement("legend", null, React.createElement("img", {
      src: "../../static/cdrom.png"
    }), "CD-ROM"), React.createElement("input", {
      id: "cdrom-input",
      type: "file",
      onChange: this.onChangeCdrom,
      style: {
        display: "none"
      }
    }), React.createElement("p", null, "windows95 comes with a virtual CD drive. It can mount images in the \"iso\" format."), React.createElement("p", {
      id: "floppy-path"
    }, cdrom ? `Inserted CD: ${cdrom === null || cdrom === void 0 ? void 0 : cdrom.path}` : `No CD mounted`), React.createElement("button", {
      className: "btn",
      onClick: () => document.querySelector("#cdrom-input").click()
    }, React.createElement("img", {
      src: "../../static/select-cdrom.png"
    }), React.createElement("span", null, "Mount CD")));
  }

  renderFloppy() {
    const {
      floppy
    } = this.props;
    return React.createElement("fieldset", null, React.createElement("legend", null, React.createElement("img", {
      src: "../../static/floppy.png"
    }), "Floppy"), React.createElement("input", {
      id: "floppy-input",
      type: "file",
      onChange: this.onChangeFloppy,
      style: {
        display: "none"
      }
    }), React.createElement("p", null, "windows95 comes with a virtual floppy drive. It can mount floppy disk images in the \"img\" format."), React.createElement("p", null, "Back in the 90s and before CD-ROMs became a popular, software was typically distributed on floppy disks. Some developers have since released their apps or games for free, usually on virtual floppy disks using the \"img\" format."), React.createElement("p", null, "Once you've mounted a disk image, you might have to boot your virtual windows95 machine from scratch."), React.createElement("p", {
      id: "floppy-path"
    }, floppy ? `Inserted Floppy Disk: ${floppy.path}` : `No floppy mounted`), React.createElement("button", {
      className: "btn",
      onClick: () => document.querySelector("#floppy-input").click()
    }, React.createElement("img", {
      src: "../../static/select-floppy.png"
    }), React.createElement("span", null, "Mount floppy disk")));
  }

  renderState() {
    const {
      isStateReset
    } = this.state;
    const {
      bootFromScratch
    } = this.props;
    return React.createElement("fieldset", null, React.createElement("legend", null, React.createElement("img", {
      src: "../../static/reset.png"
    }), "Reset machine state"), React.createElement("div", null, React.createElement("p", null, "windows95 stores changes to your machine (like saved files) in a state file. If you encounter any trouble, you can reset your state or boot Windows 95 from scratch.", " ", React.createElement("strong", null, "All your changes will be lost.")), React.createElement("button", {
      className: "btn",
      onClick: this.onResetState,
      disabled: isStateReset,
      style: {
        marginRight: "5px"
      }
    }, React.createElement("img", {
      src: "../../static/reset-state.png"
    }), isStateReset ? "State reset" : "Reset state"), React.createElement("button", {
      className: "btn",
      onClick: bootFromScratch
    }, React.createElement("img", {
      src: "../../static/boot-fresh.png"
    }), "Boot from scratch")));
  }
  /**
   * Handle a change in the floppy input
   *
   * @param event
   */


  onChangeFloppy(event) {
    const floppyFile = event.target.files && event.target.files.length > 0 ? event.target.files[0] : null;

    if (floppyFile) {
      this.props.setFloppy(floppyFile);
    } else {
      console.log(`Floppy: Input changed but no file selected`);
    }
  }
  /**
   * Handle a change in the cdrom input
   *
   * @param event
   */


  onChangeCdrom(event) {
    const CdromFile = event.target.files && event.target.files.length > 0 ? event.target.files[0] : null;

    if (CdromFile) {
      this.props.setCdrom(CdromFile);
    } else {
      console.log(`Cdrom: Input changed but no file selected`);
    }
  }
  /**
   * Handle the state reset
   */


  async onResetState() {
    const statePath = await (0, get_state_path_1.getStatePath)();

    if (fs.existsSync(statePath)) {
      await fs.remove(statePath);
    }

    this.setState({
      isStateReset: true
    });
  }

}

exports.CardSettings = CardSettings;
},{"./utils/get-state-path":"src/renderer/utils/get-state-path.ts"}],"src/renderer/emulator-info.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmulatorInfo = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

class EmulatorInfo extends React.Component {
  constructor(props) {
    super(props);
    this.cpuInterval = -1;
    this.cpuCount = this.cpuCount.bind(this);
    this.onIDEReadStart = this.onIDEReadStart.bind(this);
    this.onIDEReadWriteEnd = this.onIDEReadWriteEnd.bind(this);
    this.state = {
      cpu: 0,
      disk: "Idle",
      lastCounter: 0,
      lastTick: 0
    };
  }

  render() {
    const {
      cpu,
      disk
    } = this.state;
    return React.createElement("div", {
      id: "status"
    }, "Disk: ", React.createElement("span", null, disk), " | CPU Speed: ", React.createElement("span", null, cpu), " |", " ", React.createElement("a", {
      href: "#",
      onClick: this.props.toggleInfo
    }, "Hide"));
  }

  componentWillUnmount() {
    this.uninstallListeners();
  }
  /**
   * The emulator starts whenever, so install or uninstall listeners
   * at the right time
   *
   * @param newProps
   */


  componentDidUpdate(prevProps) {
    if (prevProps.emulator !== this.props.emulator) {
      if (this.props.emulator) {
        this.installListeners();
      } else {
        this.uninstallListeners();
      }
    }
  }
  /**
   * Let's start listening to what the emulator is up to.
   */


  installListeners() {
    const {
      emulator
    } = this.props;

    if (!emulator) {
      console.log(`Emulator info: Tried to install listeners, but emulator not defined yet.`);
      return;
    } // CPU


    if (this.cpuInterval > -1) {
      clearInterval(this.cpuInterval);
    } // TypeScript think's we're using a Node.js setInterval. We're not.


    this.cpuInterval = setInterval(this.cpuCount, 500); // Disk

    emulator.add_listener("ide-read-start", this.onIDEReadStart);
    emulator.add_listener("ide-read-end", this.onIDEReadWriteEnd);
    emulator.add_listener("ide-write-end", this.onIDEReadWriteEnd); // Screen

    emulator.add_listener("screen-set-size-graphical", console.log);
  }
  /**
   * Stop listening to the emulator.
   */


  uninstallListeners() {
    const {
      emulator
    } = this.props;

    if (!emulator) {
      console.log(`Emulator info: Tried to uninstall listeners, but emulator not defined yet.`);
      return;
    } // CPU


    if (this.cpuInterval > -1) {
      clearInterval(this.cpuInterval);
    } // Disk


    emulator.remove_listener("ide-read-start", this.onIDEReadStart);
    emulator.remove_listener("ide-read-end", this.onIDEReadWriteEnd);
    emulator.remove_listener("ide-write-end", this.onIDEReadWriteEnd); // Screen

    emulator.remove_listener("screen-set-size-graphical", console.log);
  }
  /**
   * The virtual IDE is handling read (start).
   */


  onIDEReadStart() {
    this.requestIdle(() => this.setState({
      disk: "Read"
    }));
  }
  /**
   * The virtual IDE is handling read/write (end).
   */


  onIDEReadWriteEnd() {
    this.requestIdle(() => this.setState({
      disk: "Idle"
    }));
  }
  /**
   * Request an idle callback with a 3s timeout.
   *
   * @param fn
   */


  requestIdle(fn) {
    window.requestIdleCallback(fn, {
      timeout: 3000
    });
  }
  /**
   * Calculates what's up with the virtual cpu.
   */


  cpuCount() {
    const {
      lastCounter,
      lastTick
    } = this.state;
    const now = Date.now();
    const instructionCounter = this.props.emulator.get_instruction_counter();
    const ips = instructionCounter - lastCounter;
    const deltaTime = now - lastTick;
    this.setState({
      lastTick: now,
      lastCounter: instructionCounter,
      cpu: Math.round(ips / deltaTime)
    });
  }

}

exports.EmulatorInfo = EmulatorInfo;
},{}],"src/renderer/card-drive.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardDrive = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

class CardDrive extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }

  render() {
    let advice = null;

    if (process.platform === "win32") {
      advice = this.renderAdviceWindows();
    } else if (process.platform === "darwin") {
      advice = this.renderAdviceMac();
    } else {
      advice = this.renderAdviceLinux();
    }

    return React.createElement("section", null, React.createElement("div", {
      className: "card settings"
    }, React.createElement("div", {
      className: "card-header"
    }, React.createElement("h2", {
      className: "card-title"
    }, React.createElement("img", {
      src: "../../static/drive.png"
    }), "Modify C: Drive")), React.createElement("div", {
      className: "card-body"
    }, React.createElement("p", null, "windows95 (this app) uses a raw disk image. Windows 95 (the operating system) is fragile, so adding or removing files is risky."), advice)));
  }

  renderAdviceWindows() {
    return React.createElement("fieldset", null, React.createElement("legend", null, "Changing the disk on Windows"), React.createElement("p", null, "Windows 10 cannot mount raw disk images (ironically, macOS and Linux can). However, tools exist that let you mount this drive, like the freeware tool", " ", React.createElement("a", {
      target: "_blank",
      href: "https://www.osforensics.com/tools/mount-disk-images.html"
    }, "OSFMount"), ". I am not affiliated with it, so please use it at your own risk."), this.renderMountButton("Windows Explorer"));
  }

  renderAdviceMac() {
    return React.createElement("fieldset", null, React.createElement("legend", null, "Changing the disk on macOS"), React.createElement("p", null, "macOS can mount the disk image directly. Click the button below to see the disk image in Finder. Then, double-click the image to mount it."), this.renderMountButton("Finder"));
  }

  renderAdviceLinux() {
    return React.createElement("fieldset", null, React.createElement("legend", null, "Changing the disk on Linux"), React.createElement("p", null, "There are plenty of tools that enable Linux users to mount and modify disk images. The disk image used by windows95 is a raw \"img\" disk image and can probably be mounted using the ", React.createElement("code", null, "mount"), " tool, which is likely installed on your machine."), this.renderMountButton("file viewer"));
  }

  renderMountButton(explorer) {
    return React.createElement("button", {
      className: "btn",
      onClick: this.props.showDiskImage
    }, React.createElement("img", {
      src: "../../static/show-disk-image.png"
    }), React.createElement("span", null, "Show disk image in ", explorer));
  }

}

exports.CardDrive = CardDrive;
},{}],"src/renderer/emulator.tsx":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Emulator = void 0;

const tslib_1 = require("tslib");

const React = tslib_1.__importStar(require("react"));

const fs = tslib_1.__importStar(require("fs-extra"));

const path = tslib_1.__importStar(require("path"));

const electron_1 = require("electron");

const constants_1 = require("../constants");

const disk_image_size_1 = require("../utils/disk-image-size");

const card_start_1 = require("./card-start");

const start_menu_1 = require("./start-menu");

const card_settings_1 = require("./card-settings");

const emulator_info_1 = require("./emulator-info");

const card_drive_1 = require("./card-drive");

const get_state_path_1 = require("./utils/get-state-path");

class Emulator extends React.Component {
  constructor(props) {
    super(props);
    this.isQuitting = false;
    this.isResetting = false;
    this.startEmulator = this.startEmulator.bind(this);
    this.stopEmulator = this.stopEmulator.bind(this);
    this.restartEmulator = this.restartEmulator.bind(this);
    this.resetEmulator = this.resetEmulator.bind(this);
    this.bootFromScratch = this.bootFromScratch.bind(this);
    this.state = {
      isBootingFresh: false,
      isCursorCaptured: false,
      isRunning: false,
      currentUiCard: "start",
      isInfoDisplayed: true,
      // We can start pretty large
      // If it's too large, it'll just grow until it hits borders
      scale: 2
    };
    this.setupInputListeners();
    this.setupIpcListeners();
    this.setupUnloadListeners();

    if (document.location.hash.includes("AUTO_START")) {
      this.startEmulator();
    }
  }
  /**
   * We want to capture and release the mouse at appropriate times.
   */


  setupInputListeners() {
    // ESC
    document.onkeydown = evt => {
      const {
        isCursorCaptured
      } = this.state;
      evt = evt || window.event;

      if (evt.keyCode === 27) {
        if (isCursorCaptured) {
          this.unlockMouse();
        } else {
          this.lockMouse();
        }

        evt.stopPropagation();
      }
    }; // Click


    document.addEventListener("click", () => {
      const {
        isRunning
      } = this.state;

      if (isRunning) {
        this.lockMouse();
      }
    });
  }
  /**
   * Save the emulator's state to disk during exit.
   */


  setupUnloadListeners() {
    const handleClose = async () => {
      await this.saveState();
      console.log(`Unload: Now done, quitting again.`);
      this.isQuitting = true;
      setImmediate(() => {
        electron_1.ipcRenderer.invoke(constants_1.IPC_COMMANDS.APP_QUIT);
      });
    };

    window.onbeforeunload = event => {
      if (this.isQuitting || this.isResetting) {
        console.log(`Unload: Not preventing`);
        return;
      }

      console.log(`Unload: Preventing to first save state`);
      handleClose();
      event.preventDefault();
      event.returnValue = false;
    };
  }
  /**
   * Setup the various IPC messages sent to the renderer
   * from the main process
   */


  setupIpcListeners() {
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_CTRL_ALT_DEL, () => {
      this.sendKeys([0x1d, 0x38, 0x53 // delete
      ]);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_ALT_F4, () => {
      this.sendKeys([0x38, 0x3e // f4
      ]);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_ALT_ENTER, () => {
      this.sendKeys([0x38, 0 // enter
      ]);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_ESC, () => {
      this.sendKeys([0x18 // alt
      ]);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_STOP, this.stopEmulator);
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_RESET, this.resetEmulator);
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_START, this.startEmulator);
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.MACHINE_RESTART, this.restartEmulator);
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.TOGGLE_INFO, () => {
      this.setState({
        isInfoDisplayed: !this.state.isInfoDisplayed
      });
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.SHOW_DISK_IMAGE, () => {
      this.showDiskImage();
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.ZOOM_IN, () => {
      this.setScale(this.state.scale * 1.2);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.ZOOM_OUT, () => {
      this.setScale(this.state.scale * 0.8);
    });
    electron_1.ipcRenderer.on(constants_1.IPC_COMMANDS.ZOOM_RESET, () => {
      this.setScale(1);
    });
  }
  /**
   * If the emulator isn't running, this is rendering the, erm, UI.
   *
   * 🤡
   */


  renderUI() {
    const {
      isRunning,
      currentUiCard,
      floppyFile,
      cdromFile
    } = this.state;

    if (isRunning) {
      return null;
    }

    let card;

    if (currentUiCard === "settings") {
      card = React.createElement(card_settings_1.CardSettings, {
        setFloppy: floppyFile => this.setState({
          floppyFile
        }),
        setCdrom: cdromFile => this.setState({
          cdromFile
        }),
        bootFromScratch: this.bootFromScratch,
        floppy: floppyFile,
        cdrom: cdromFile
      });
    } else if (currentUiCard === "drive") {
      card = React.createElement(card_drive_1.CardDrive, {
        showDiskImage: this.showDiskImage
      });
    } else {
      card = React.createElement(card_start_1.CardStart, {
        startEmulator: this.startEmulator
      });
    }

    return React.createElement(React.Fragment, null, card, React.createElement(start_menu_1.StartMenu, {
      navigate: target => this.setState({
        currentUiCard: target
      })
    }));
  }
  /**
   * Yaknow, render things and stuff.
   */


  render() {
    return React.createElement(React.Fragment, null, this.renderInfo(), this.renderUI(), React.createElement("div", {
      id: "emulator"
    }, React.createElement("div", null), React.createElement("canvas", null)));
  }
  /**
   * Render the little info thingy
   */


  renderInfo() {
    if (!this.state.isInfoDisplayed) {
      return null;
    }

    return React.createElement(emulator_info_1.EmulatorInfo, {
      emulator: this.state.emulator,
      toggleInfo: () => {
        this.setState({
          isInfoDisplayed: !this.state.isInfoDisplayed
        });
      }
    });
  }
  /**
   * Boot the emulator without restoring state
   */


  bootFromScratch() {
    this.setState({
      isBootingFresh: true
    });
    this.startEmulator();
  }
  /**
   * Show the disk image on disk
   */


  showDiskImage() {
    // Contents/Resources/app/dist/static
    const imagePath = path.join(__dirname, "../../images/windows95.img");
    console.log(`Showing disk image in ${imagePath}`);
    electron_1.shell.showItemInFolder(imagePath);
  }
  /**
   * Start the actual emulator
   */


  async startEmulator() {
    document.body.classList.remove("paused");
    const cdrom = {};
    const cdromFile = this.state.cdromFile;

    if (cdromFile === null || cdromFile === void 0 ? void 0 : cdromFile.path) {
      cdrom.url = cdromFile.path;
      cdrom.async = true;
      cdrom.size = await (0, disk_image_size_1.getDiskImageSize)(cdromFile.path);
    }

    const options = {
      wasm_path: path.join(__dirname, "build/v86.wasm"),
      memory_size: 128 * 1024 * 1024,
      vga_memory_size: 32 * 1024 * 1024,
      screen_container: document.getElementById("emulator"),
      bios: {
        url: path.join(__dirname, "../../bios/seabios.bin")
      },
      vga_bios: {
        url: path.join(__dirname, "../../bios/vgabios.bin")
      },
      hda: {
        url: constants_1.CONSTANTS.IMAGE_PATH,
        async: true,
        size: await (0, disk_image_size_1.getDiskImageSize)(constants_1.CONSTANTS.IMAGE_PATH)
      },
      fda: {
        buffer: this.state.floppyFile
      },
      cdrom: cdrom,
      boot_order: 0x132 // One day, maybe!
      // network_relay_url: "ws://localhost:8080/"

    };
    console.log(`🚜 Starting emulator with options`, options);
    window["emulator"] = new V86Starter(options); // New v86 instance

    this.setState({
      emulator: window["emulator"],
      isRunning: true
    });
    electron_1.ipcRenderer.send(constants_1.IPC_COMMANDS.MACHINE_STARTED); // Restore state. We can't do this right away
    // and randomly chose 500ms as the appropriate
    // wait time (lol)

    setTimeout(async () => {
      if (!this.state.isBootingFresh) {
        this.restoreState();
      }

      this.lockMouse();
      this.state.emulator.run();
      this.state.emulator.screen_set_scale(this.state.scale);
    }, 500);
  }
  /**
   * Restart emulator
   */


  restartEmulator() {
    if (this.state.emulator && this.state.isRunning) {
      console.log(`🚜 Restarting emulator`);
      this.state.emulator.restart();
    } else {
      console.log(`🚜 Restarting emulator failed: Emulator not running`);
    }
  }
  /**
   * Stop the emulator
   */


  async stopEmulator() {
    const {
      emulator,
      isRunning
    } = this.state;

    if (!emulator || !isRunning) {
      return;
    }

    console.log(`🚜 Stopping emulator`);
    await this.saveState();
    this.unlockMouse();
    await emulator.stop();
    this.setState({
      isRunning: false
    });
    document.body.classList.add("paused");
    electron_1.ipcRenderer.send(constants_1.IPC_COMMANDS.MACHINE_STOPPED);
  }
  /**
   * Reset the emulator by reloading the whole page (lol)
   */


  async resetEmulator() {
    this.isResetting = true;
    document.location.hash = `#AUTO_START`;
    document.location.reload();
  }
  /**
   * Take the emulators state and write it to disk. This is possibly
   * a fairly big file.
   */


  async saveState() {
    const {
      emulator
    } = this.state;
    const statePath = await (0, get_state_path_1.getStatePath)();

    if (!emulator || !emulator.save_state) {
      console.log(`restoreState: No emulator present`);
      return;
    }

    try {
      const newState = await emulator.save_state();
      await fs.outputFile(statePath, Buffer.from(newState));
    } catch (error) {
      console.warn(`saveState: Could not save state`, error);
    }
  }
  /**
   * Restores state to the emulator.
   */


  async restoreState() {
    const {
      emulator
    } = this.state;
    const state = await this.getState(); // Nothing to do with if we don't have a state

    if (!state) {
      console.log(`restoreState: No state present, not restoring.`);
    }

    if (!emulator) {
      console.log(`restoreState: No emulator present`);
    }

    try {
      await this.state.emulator.restore_state(state);
    } catch (error) {
      console.log(`State: Could not read state file. Maybe none exists?`, error);
    }
  }
  /**
   * Returns the current machine's state - either what
   * we have saved or alternatively the default state.
   *
   * @returns {ArrayBuffer}
   */


  async getState() {
    const expectedStatePath = await (0, get_state_path_1.getStatePath)();
    const statePath = fs.existsSync(expectedStatePath) ? expectedStatePath : constants_1.CONSTANTS.DEFAULT_STATE_PATH;

    if (fs.existsSync(statePath)) {
      return fs.readFileSync(statePath).buffer;
    }

    return null;
  }

  unlockMouse() {
    const {
      emulator
    } = this.state;
    this.setState({
      isCursorCaptured: false
    });

    if (emulator) {
      emulator.mouse_set_status(false);
    }

    document.exitPointerLock();
  }

  lockMouse() {
    const {
      emulator
    } = this.state;

    if (emulator) {
      this.setState({
        isCursorCaptured: true
      });
      emulator.mouse_set_status(true);
      emulator.lock_mouse();
    } else {
      console.warn(`Emulator: Tried to lock mouse, but no emulator or not running`);
    }
  }
  /**
   * Set the emulator's scale
   *
   * @param target
   */


  setScale(target) {
    const {
      emulator,
      isRunning
    } = this.state;

    if (emulator && isRunning) {
      emulator.screen_set_scale(target);
      this.setState({
        scale: target
      });
    }
  }
  /**
   * Send keys to the emulator (including the key-up),
   * if it's running
   *
   * @param {Array<number>} codes
   */


  sendKeys(codes) {
    if (this.state.emulator && this.state.isRunning) {
      const scancodes = codes; // Push break codes (key-up)

      for (const scancode of scancodes) {
        scancodes.push(scancode | 0x80);
      }

      this.state.emulator.keyboard_send_scancodes(scancodes);
    }
  }

}

exports.Emulator = Emulator;
},{"../constants":"src/constants.ts","../utils/disk-image-size":"src/utils/disk-image-size.ts","./card-start":"src/renderer/card-start.tsx","./start-menu":"src/renderer/start-menu.tsx","./card-settings":"src/renderer/card-settings.tsx","./emulator-info":"src/renderer/emulator-info.tsx","./card-drive":"src/renderer/card-drive.tsx","./utils/get-state-path":"src/renderer/utils/get-state-path.ts"}],"src/renderer/app.tsx":[function(require,module,exports) {
"use strict";

var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);

  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }

  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);

  __setModuleDefault(result, mod);

  return result;
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
/**
 * The top-level class controlling the whole app. This is *not* a React component,
 * but it does eventually render all components.
 *
 * @class App
 */

class App {
  /**
   * Initial setup call, loading Monaco and kicking off the React
   * render process.
   */
  async setup() {
    const React = await Promise.resolve().then(() => __importStar(require("react")));
    const {
      render
    } = await Promise.resolve().then(() => __importStar(require("react-dom")));
    const {
      Emulator
    } = await Promise.resolve().then(() => __importStar(require("./emulator")));
    const className = `${process.platform}`;
    const app = React.createElement("div", {
      className: className
    }, React.createElement(Emulator, null));
    const rendered = render(app, document.getElementById("app"));
    return rendered;
  }

}

exports.App = App;
window["win95"] = window["win95"] || {
  app: new App()
};
window["win95"].app.setup();
},{"./emulator":"src/renderer/emulator.tsx"}]},{},["src/renderer/app.tsx"], null)
//# sourceMappingURL=../app.15fac660.js.map