library(shiny)
library("lpSolve")
library("lpSolveAPI")

data <- read.csv("data.csv", header=FALSE, sep=";")

data <- as.matrix(data)

#heat_paper <- matrix(c(-5,0,0,-5,0,0), nrow = 3)

heat_paper_old <- data

heat_paper <- data
#row_p <- nrow(heat_paper)

# number of characteristics

#col_p <- ncol(heat_paper)

paper_tune <- function(heat_paper, setting = rep(4, ncol(heat_paper)), 
                       cost = rep(0, 2*nrow(heat_paper)), B = 100, integer_opt = TRUE){
    library(lpSolve)
    ###
    # heat_paper: matrix, heat map of relationship, k*l, k is the number of factors, l is the number of 
    # characteristics
    # setting: vector, 1: increase, 2: decrease, 3: do not change, 4: do not care 
    ###
    
    # number of factors
    
    row_p <- nrow(heat_paper)
    
    # number of characteristics
    
    col_p <- ncol(heat_paper)
    
    ## Specifying the deviation variables based on change specifications
    
    obj_1 <- numeric()
    
    for(i in 1:length(setting)){
        obj_1 <- c(obj_1, switch(setting[i], 
                                 "1" = c(1,0), "2" = c(0,1), "3" = c(-1,-1),"4" = c(0,0)))
    }
    #print(obj_1)
    
    ## The coefficients in the objective function
    f.obj <- c(rep(0, 2 * row_p), obj_1)
    
    ## Left side on constraints
    
    obj_2 <- numeric()
    
    for(i in 1:length(setting)){
        obj_2 <- c(obj_2, switch(setting[i], 
                                 "1" = c(-1,0), "2" = c(0,1), "3" = c(-1,1),"4" = c(0,0)))
    }
    #print(obj_2)
    
    ## Deviation constraints
    const <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(heat_paper[,i], -heat_paper[,i], rep(c(0,0),i-1), obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const <- c(const, const_1)
    }
    #print(const)
    
    ## Non-negativity constraints
    #       non_neg <- numeric()
    #       for(i in 1:(2*ncol(heat_paper))){
    #           non_neg_1 <- c(rep(0,nrow(heat_paper)), rep(0,i-1), 1, 
    #                        rep(0,2*ncol(heat_paper)-i))
    #           non_neg <- c(non_neg, non_neg_1)
    #       }
    #       f.con <- matrix(c(const,non_neg), ncol=(nrow(heat_paper) + 2 * ncol(heat_paper)), byrow=TRUE)
    
    ## Factor change constraints, smaller than 1 and greater than -1
    factor_change_a <- numeric()
    for(i in 1:row_p){
        factor_change_a_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), -1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_a <- c(factor_change_a, factor_change_a_1)
    }
    
    ## The sum of the positive and negative part is not greater than 1
    factor_change_b <- numeric()
    for(i in 1:row_p){
        factor_change_b_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_b <- c(factor_change_b, factor_change_b_1)
    }
    #print(factor_change_b)
    
    ## Constraint on cost
    
    cost_con <- c(cost, rep(0, 2*col_p))
    
    
    f.con <- matrix(c(const,factor_change_b, cost_con), 
                    ncol=(2 * row_p + 2 * col_p), byrow=TRUE)
    #print(f.con)
    ## Direction of constraints
    
    f.dir <- c(rep("=",col_p), rep("<=", row_p), "<=")
    
    # The right sides of constraints
    
    f.rhs <- c(rep(0,col_p), rep(1, row_p), B)
    
    ## Specifying whether integer solution or real number
    if(integer_opt){
        integer_spec <- c(1:(2*row_p))
    }else{
        integer_spec <- c()
    }
    #print(integer_spec)
    solution1 <- lp ("max", f.obj, f.con, f.dir, f.rhs, int.vec = integer_spec)
    
    solution1$solution
    solution1$solution[1:row_p] - solution1$solution[(row_p+1):(2*row_p)]
    #print(sol)
    #solution1
#     final <- rep(1, nrow(heat_paper))
#     for(i in 1:nrow(heat_paper)){
#         final[i] <- if(sol[i] == 1){
#             "increased"
#         }else if(sol[i] == 0){
#             "left unchanged"
#         }else{
#             "decreased"
#         }
#     }
#     for(i in 1:nrow(heat_paper)){
#         print(paste("Factor", i, "should be: ",sol[i]))
#     }
    #const
}

paper_tune_1 <- function(heat_paper, setting = rep(4, ncol(heat_paper)), 
                       cost = rep(0, 2*nrow(heat_paper)), B = 100, integer_opt = TRUE){
    library(lpSolve)
    ###
    # heat_paper: matrix, heat map of relationship, k*l, k is the number of factors, l is the number of 
    # characteristics
    # setting: vector, 1: increase, 2: decrease, 3: do not change, 4: do not care 
    ###
    
    # number of factors
    
    row_p <- nrow(heat_paper)
    
    # number of characteristics
    
    col_p <- ncol(heat_paper)
    
    ## Specifying the deviation variables based on change specifications
    
    obj_1 <- numeric()
    
    for(i in 1:length(setting)){
        obj_1 <- c(obj_1, switch(setting[i], 
                                 "1" = c(1,0), "2" = c(0,1), "3" = c(-1,-1),"4" = c(0,0)))
    }
    #print(obj_1)
    
    ## The coefficients in the objective function
    f.obj <- c(rep(0, 2 * row_p), obj_1)
    
    ## Left side on constraints
    
    obj_2 <- numeric()
    
    for(i in 1:length(setting)){
        obj_2 <- c(obj_2, switch(setting[i], 
                                 "1" = c(-1,0), "2" = c(0,1), "3" = c(-1,1),"4" = c(0,0)))
    }
    #print(obj_2)
    
    ## Deviation constraints
    const <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(heat_paper[,i], -heat_paper[,i], rep(c(0,0),i-1), obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const <- c(const, const_1)
    }
    #print(const)
    
    ## Non-negativity constraints
    #       non_neg <- numeric()
    #       for(i in 1:(2*ncol(heat_paper))){
    #           non_neg_1 <- c(rep(0,nrow(heat_paper)), rep(0,i-1), 1, 
    #                        rep(0,2*ncol(heat_paper)-i))
    #           non_neg <- c(non_neg, non_neg_1)
    #       }
    #       f.con <- matrix(c(const,non_neg), ncol=(nrow(heat_paper) + 2 * ncol(heat_paper)), byrow=TRUE)
    
    ## Factor change constraints, smaller than 1 and greater than -1
    factor_change_a <- numeric()
    for(i in 1:row_p){
        factor_change_a_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), -1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_a <- c(factor_change_a, factor_change_a_1)
    }
    
    ## The sum of the positive and negative part is not greater than 1
    factor_change_b <- numeric()
    for(i in 1:row_p){
        factor_change_b_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_b <- c(factor_change_b, factor_change_b_1)
    }
    #print(factor_change_b)
    
    ## Constraint on cost
    
    cost_con <- c(cost, rep(0, 2*col_p))
    
    
    f.con <- matrix(c(const,factor_change_b, cost_con), 
                    ncol=(2 * row_p + 2 * col_p), byrow=TRUE)
    #print(f.con)
    ## Direction of constraints
    
    f.dir <- c(rep("=",col_p), rep("<=", row_p), "<=")
    
    # The right sides of constraints
    
    f.rhs <- c(rep(0,col_p), rep(1, row_p), B)
    
    ## Specifying whether integer solution or real number
    if(integer_opt){
        integer_spec <- c(1:(2*row_p))
    }else{
        integer_spec <- c()
    }
    #print(integer_spec)
    lp ("max", f.obj, f.con, f.dir, f.rhs, int.vec = integer_spec)$objval

    #print(sol)
    #solution1
    #     final <- rep(1, nrow(heat_paper))
    #     for(i in 1:nrow(heat_paper)){
    #         final[i] <- if(sol[i] == 1){
    #             "increased"
    #         }else if(sol[i] == 0){
    #             "left unchanged"
    #         }else{
    #             "decreased"
    #         }
    #     }
    #     for(i in 1:nrow(heat_paper)){
    #         print(paste("Factor", i, "should be: ",sol[i]))
    #     }
    #const
}

paper_tune_pos <- function(heat_paper, lower = heat_paper - 1, upper = heat_paper + 1, 
                           setting = rep(4, ncol(heat_paper)), 
                           cost = rep(0, 2*nrow(heat_paper)), B = 100, eta = 1){
    library(lpSolve)
    ###
    # heat_paper: matrix, heat map of relationship, k*l, k is the number of factors, l is the number of 
    # characteristics
    # setting: vector, 1: increase, 2: decrease, 3: do not change, 4: do not care 
    ###
    
    # number of factors
    
    row_p <- nrow(heat_paper)
    
    # number of characteristics
    
    col_p <- ncol(heat_paper)
    
    ## Specifying the deviation variables based on change specifications
    
    obj_1 <- numeric()
    
    for(i in 1:length(setting)){
        obj_1 <- c(obj_1, switch(setting[i], 
                                 "1" = c(1,0), "2" = c(0,1), "3" = c(-1,-1),"4" = c(0,0)))
    }
    #print(obj_1)
    
    ## The coefficients in the objective function
    f.obj <- c(rep(0, 2 * row_p), obj_1)
    
    ## Left side on constraints
    
    obj_2 <- numeric()
    
    for(i in 1:length(setting)){
        obj_2 <- c(obj_2, switch(setting[i], 
                                 "1" = c(-1,0), "2" = c(0,1), "3" = c(-1,1),"4" = c(0,0)))
    }
    print(obj_2)
    
    ## Deviation constraints
    
    ### Lower
    const_lower <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(eta * heat_paper[,i] + (1 - eta) * lower[,i], 
                         - eta * heat_paper[,i] - (1 - eta) * lower[,i], rep(c(0,0),i-1), 
                         obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const_lower <- c(const_lower, const_1)
    }
    
    ## Upper
    const_upper <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(eta * heat_paper[,i] + (1 - eta) * upper[,i], 
                         - eta * heat_paper[,i] - (1 - eta) * upper[,i], rep(c(0,0),i-1), 
                         obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const_upper <- c(const_upper, const_1)
    }
    #print(const)
    
    ## Factor change constraints, smaller than 1 and greater than -1
    factor_change_a <- numeric()
    for(i in 1:row_p){
        factor_change_a_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), -1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_a <- c(factor_change_a, factor_change_a_1)
    }
    
    ## The sum of the positive and negative part is not greater than 1
    factor_change_b <- numeric()
    for(i in 1:row_p){
        factor_change_b_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_b <- c(factor_change_b, factor_change_b_1)
    }
    #print(factor_change_b)
    
    ## Constraint on cost
    
    cost_con <- c(cost, rep(0, 2*col_p))
    
    
    f.con <- matrix(c(const_lower, const_upper, factor_change_b, cost_con), 
                    ncol=(2 * row_p + 2 * col_p), byrow=TRUE)
    print(f.con)
    ## Direction of constraints
    
    f.dir <- c(rep("<=",col_p), rep(">=",col_p), rep("<=", row_p), "<=")
    
    # The right sides of constraints
    
    f.rhs <- c(rep(0,col_p), rep(0,col_p), rep(1, row_p), B)
    
    solution1 <- lp ("max", f.obj, f.con, f.dir, f.rhs, int.vec = c(1:(2*row_p)))
    
    solution1$solution
    solution1$solution[1:row_p] - solution1$solution[(row_p+1):(2*row_p)]
    #solution1
    #const
}


#heat_paper <- matrix(c(-3,1,3,-3,1,3), nrow = 3)
library(gplots)
# heatmap.2(heat_paper, Rowv=FALSE, Colv=FALSE, 
#           dendrogram="none", col=redblue(16), 
#           key=T, keysize=1.5, density.info="none", 
#           trace="none", labRow=NA)
# Define server logic required to draw a histogram

shinyServer(function(input, output) {
  
  # Expression that generates a histogram. The expression is
  # wrapped in a call to renderPlot to indicate that:
  #
  #  1) It is "reactive" and therefore should re-execute automatically
  #     when inputs change
  #  2) Its output type is a plot
  output$hmat <- renderTable({
      heat_paper
  })
  output$heat <- renderPlot({
#       inFile <- input$file1
#       
#       if (is.null(inFile))
#           return(NULL)
#       input_data <- read.csv(inFile$datapath, header = FALSE, sep=";")
#       print(input_data)
#       #heat_data
#       if(input$data_used){
#           heat_data <- as.matrix(input_data)
#       }else{
#           heat_data <- heat_paper_old
#       }
      heat_data <- heat_paper_old
      heatmap.2(heat_data, Rowv=FALSE, Colv=FALSE, 
                dendrogram="none", col=bluered(100), main = "The heatmap of relationship 
                between factors and characteristics",
                key=T, keysize=1.3, density.info="none", 
                trace="none", labRow="", labCol = "", 
                notecex=3.0, srtCol=0, cexCol = 2)
      #cellnote = heat_paper
  })
  output$optimal <- renderUI({
#       for(i in 1:ncol(heat_paper)){
#           s <- as.character(i)
#           setting <- c(setting, paste("input$ch",s, sep = "_"))
#       }
      setting <- c()
      setting <- c(setting, input$ch_1)
      setting <- c(setting, input$ch_2)
      setting <- c(setting, input$ch_3)
      setting <- c(setting, input$ch_4)
      setting <- c(setting, input$ch_5)
      setting <- c(setting, input$ch_6)
      setting <- c(setting, input$ch_7)
      setting <- c(setting, input$ch_8)
      setting <- c(setting, input$ch_9)
      setting <- c(setting, input$ch_10)
      setting <- c(setting, input$ch_11)
      setting <- c(setting, input$ch_12)
      setting <- c(setting, input$ch_13)
      setting <- c(setting, input$ch_14)
      setting <- c(setting, input$ch_15)
      setting <- c(setting, input$ch_16)
      setting <- c(setting, input$ch_17)
      print(setting)
      cost <- rep(1, 2*nrow(heat_paper))
      B <- input$num
      if(input$poss_sol){
          sol <- paper_tune(heat_paper, setting, cost, B, integer_opt = input$int_sol)
      }else{
          sol <- paper_tune_pos(heat_paper, lower = heat_paper - 1, upper = heat_paper + 1, 
                                setting, 
                                cost, B, eta = 1)
      }
      sol <- round(sol, digits = 2)
      str_fin <- rep(1,nrow(heat_paper))
#       strprint(paste("Factor", 1, "should be changed by: ",sol[1]))
#       print(paste("Factor", 2, "should be changed by: ",sol[2]))
#       print(paste("Factor", 3, "should be changed by: ",sol[3]))
#       print(paste("Factor", 4, "should be changed by: ",sol[4]))
#       print(paste("Factor", 5, "should be changed by: ",sol[5]))
#       print(paste("Factor", 6, "should be changed by: ",sol[6]))
#       print(paste("Factor", 7, "should be changed by: ",sol[7]))
#       print(paste("Factor", 8, "should be changed by: ",sol[8]))
#       print(paste("Factor", 9, "should be changed by: ",sol[9]))
#       print(paste("Factor", 10, "should be changed by: ",sol[10]))
#       print(paste("Factor", 11, "should be: ",sol[11]))
#       print(paste("Factor", 12, "should be: ",sol[12]))
#       print(paste("Factor", 13, "should be: ",sol[13]))
#       print(paste("Factor", 14, "should be: ",sol[14]))
#       print(paste("Factor", 15, "should be: ",sol[15]))
#       print(paste("Factor", 16, "should be: ",sol[16]))
#       print(paste("Factor", 17, "should be: ",sol[17]))
      str_fin[1] <- paste("Factor", 1, "should be changed by: ",sol[1])
      str_fin[2] <- paste("Factor", 2, "should be changed by: ",sol[2])
      str_fin[3] <- paste("Factor", 3, "should be changed by: ",sol[3])
      str_fin[4] <- paste("Factor", 4, "should be changed by: ",sol[4])
      str_fin[5] <- paste("Factor", 5, "should be changed by: ",sol[5])
      str_fin[6] <- paste("Factor", 6, "should be changed by: ",sol[6])
      str_fin[7] <- paste("Factor", 7, "should be changed by: ",sol[7])
      str_fin[8] <- paste("Factor", 8, "should be changed by: ",sol[8])
      str_fin[9] <- paste("Factor", 9, "should be changed by: ",sol[9])
      str_fin[10] <- paste("Factor", 10, "should be changed by: ",sol[10])
      str_fin[11] <- paste("Factor", 11, "should be changed by: ",sol[11])
      str_fin[12] <- paste("Factor", 12, "should be changed by: ",sol[12])
      str_fin[13] <- paste("Factor", 13, "should be changed by: ",sol[13])
      str_fin[14] <- paste("Factor", 14, "should be changed by: ",sol[14])
      str_fin[15] <- paste("Factor", 15, "should be changed by: ",sol[15])
      str_fin[16] <- paste("Factor", 16, "should be changed by: ",sol[16])
      str_fin[17] <- paste("Factor", 17, "should be changed by: ",sol[17])
      str_fin[18] <- paste("Factor", 18, "should be changed by: ",sol[18])
      str_fin[19] <- paste("Factor", 19, "should be changed by: ",sol[19])
      str_fin[20] <- paste("Factor", 20, "should be changed by: ",sol[20])
      str_fin[21] <- paste("Factor", 21, "should be changed by: ",sol[21])
      str_fin[22] <- paste("Factor", 22, "should be changed by: ",sol[22])
      str_fin[23] <- paste("Factor", 23, "should be changed by: ",sol[23])
      str_fin[24] <- paste("Factor", 24, "should be changed by: ",sol[24])
      HTML(paste(str_fin[1], str_fin[2], str_fin[3], str_fin[4], 
                 str_fin[5], str_fin[6], str_fin[7], str_fin[8],
                 str_fin[9], str_fin[10], str_fin[11], str_fin[12],
                 str_fin[13], str_fin[14], str_fin[15], str_fin[16],
                 str_fin[17], str_fin[18], str_fin[19], str_fin[20],
                 str_fin[21], str_fin[22], str_fin[23], str_fin[24], sep = '<br/>'))
#       for(i in 1:nrow(heat_paper)){
#           paste("Factor", i, "should be: ",sol[i])
#       }
#       final <- rep(1, nrow(heat_paper))
#       for(i in 1:nrow(heat_paper)){
#           final[i] <- if(sol[i] == 1){
#               "increased"
#           }else if(sol[i] == 0){
#               "left unchanged"
#           }else{
#               "decreased"
#           }
#       }
#       for(i in 1:nrow(heat_paper)){
#           print(paste("Factor", i, "should be: ",final[i]))
#           print(paste("", "", sep="\n"))
#       }
  })
  output$optimal1 <- renderText({
      #       for(i in 1:ncol(heat_paper)){
      #           s <- as.character(i)
      #           setting <- c(setting, paste("input$ch",s, sep = "_"))
      #       }
      setting <- c()
      setting <- c(setting, input$ch_1)
      setting <- c(setting, input$ch_2)
      setting <- c(setting, input$ch_3)
      setting <- c(setting, input$ch_4)
      setting <- c(setting, input$ch_5)
      setting <- c(setting, input$ch_6)
      setting <- c(setting, input$ch_7)
      setting <- c(setting, input$ch_8)
      setting <- c(setting, input$ch_9)
      setting <- c(setting, input$ch_10)
      setting <- c(setting, input$ch_11)
      setting <- c(setting, input$ch_12)
      setting <- c(setting, input$ch_13)
      setting <- c(setting, input$ch_14)
      setting <- c(setting, input$ch_15)
      setting <- c(setting, input$ch_16)
      setting <- c(setting, input$ch_17)
      #print(setting)
      cost <- rep(1, 2*nrow(heat_paper))
      B <- input$num
      print(paste("The value of the objective function is", 
                  paper_tune_1(heat_paper, setting, cost, B, integer_opt = input$int_sol)))
  })
})

# 
