
paper_tune <- function(heat_paper, setting = rep(4, ncol(heat_paper)), 
                       cost = rep(0, 2*nrow(heat_paper)), B = 100, integer_opt = TRUE){
    library(lpSolve)
    ###
    # heat_paper: matrix, heat map of relationship, k*l, k is the number of factors, l is the number of 
    # characteristics
    # setting: vector, 1: increase, 2: decrease, 3: do not change, 4: do not care 
    ###
    
    # number of factors
    
    row_p <- nrow(heat_paper)
    
    # number of characteristics
    
    col_p <- ncol(heat_paper)
    
    ## Specifying the deviation variables based on change specifications
    
    obj_1 <- numeric()
    
    for(i in 1:length(setting)){
        obj_1 <- c(obj_1, switch(setting[i], 
                                 "1" = c(1,0), "2" = c(0,1), "3" = c(-1,-1),"4" = c(0,0)))
    }
    #print(obj_1)
    
    ## The coefficients in the objective function
    f.obj <- c(rep(0, 2 * row_p), obj_1)
    
    ## Left side on constraints
    
    obj_2 <- numeric()
    
    for(i in 1:length(setting)){
        obj_2 <- c(obj_2, switch(setting[i], 
                                 "1" = c(-1,0), "2" = c(0,1), "3" = c(-1,1),"4" = c(0,0)))
    }
    #print(obj_2)
    
    ## Deviation constraints
    const <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(heat_paper[,i], -heat_paper[,i], rep(c(0,0),i-1), obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const <- c(const, const_1)
    }
    #print(const)
    
    ## Non-negativity constraints
    #       non_neg <- numeric()
    #       for(i in 1:(2*ncol(heat_paper))){
    #           non_neg_1 <- c(rep(0,nrow(heat_paper)), rep(0,i-1), 1, 
    #                        rep(0,2*ncol(heat_paper)-i))
    #           non_neg <- c(non_neg, non_neg_1)
    #       }
    #       f.con <- matrix(c(const,non_neg), ncol=(nrow(heat_paper) + 2 * ncol(heat_paper)), byrow=TRUE)
    
    ## Factor change constraints, smaller than 1 and greater than -1
    factor_change_a <- numeric()
    for(i in 1:row_p){
        factor_change_a_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), -1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_a <- c(factor_change_a, factor_change_a_1)
    }
    
    ## The sum of the positive and negative part is not greater than 1
    factor_change_b <- numeric()
    for(i in 1:row_p){
        factor_change_b_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_b <- c(factor_change_b, factor_change_b_1)
    }
    #print(factor_change_b)
    
    ## Constraint on cost
    
    cost_con <- c(cost, rep(0, 2*col_p))
    
    
    f.con <- matrix(c(const,factor_change_b, cost_con), 
                    ncol=(2 * row_p + 2 * col_p), byrow=TRUE)
    #print(f.con)
    ## Direction of constraints
    
    f.dir <- c(rep("=",col_p), rep("<=", row_p), "<=")
    
    # The right sides of constraints
    
    f.rhs <- c(rep(0,col_p), rep(1, row_p), B)
    
    ## Specifying whether integer solution or real number
    if(integer_opt){
        integer_spec <- c(1:(2*row_p))
    }else{
        integer_spec <- c()
    }
    #print(integer_spec)
    lp ("max", f.obj, f.con, f.dir, f.rhs, int.vec = integer_spec)$objval

    #print(sol)
    #solution1
    #     final <- rep(1, nrow(heat_paper))
    #     for(i in 1:nrow(heat_paper)){
    #         final[i] <- if(sol[i] == 1){
    #             "increased"
    #         }else if(sol[i] == 0){
    #             "left unchanged"
    #         }else{
    #             "decreased"
    #         }
    #     }
    #     for(i in 1:nrow(heat_paper)){
    #         print(paste("Factor", i, "should be: ",sol[i]))
    #     }
    #const
}

paper_tune_pos <- function(heat_paper, lower = heat_paper - 1, upper = heat_paper + 1, 
                           setting = rep(4, ncol(heat_paper)), 
                           cost = rep(0, 2*nrow(heat_paper)), B = 100, eta = 1){
    library(lpSolve)
    ###
    # heat_paper: matrix, heat map of relationship, k*l, k is the number of factors, l is the number of 
    # characteristics
    # setting: vector, 1: increase, 2: decrease, 3: do not change, 4: do not care 
    ###
    
    # number of factors
    
    row_p <- nrow(heat_paper)
    
    # number of characteristics
    
    col_p <- ncol(heat_paper)
    
    ## Specifying the deviation variables based on change specifications
    
    obj_1 <- numeric()
    
    for(i in 1:length(setting)){
        obj_1 <- c(obj_1, switch(setting[i], 
                                 "1" = c(1,0), "2" = c(0,1), "3" = c(-1,-1),"4" = c(0,0)))
    }
    #print(obj_1)
    
    ## The coefficients in the objective function
    f.obj <- c(rep(0, 2 * row_p), obj_1)
    
    ## Left side on constraints
    
    obj_2 <- numeric()
    
    for(i in 1:length(setting)){
        obj_2 <- c(obj_2, switch(setting[i], 
                                 "1" = c(-1,0), "2" = c(0,1), "3" = c(-1,1),"4" = c(0,0)))
    }
    print(obj_2)
    
    ## Deviation constraints
    
    ### Lower
    const_lower <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(eta * heat_paper[,i] + (1 - eta) * lower[,i], 
                         - eta * heat_paper[,i] - (1 - eta) * lower[,i], rep(c(0,0),i-1), 
                         obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const_lower <- c(const_lower, const_1)
    }
    
    ## Upper
    const_upper <- numeric()
    for(i in 1:col_p){
        if(setting[i]==4){
            const_1 <- c(rep(0,2*row_p+2*col_p))
        }
        else{
            const_1 <- c(eta * heat_paper[,i] + (1 - eta) * upper[,i], 
                         - eta * heat_paper[,i] - (1 - eta) * upper[,i], rep(c(0,0),i-1), 
                         obj_2[(1+(i-1)*2):(2+(i-1)*2)], 
                         rep(c(0,0),col_p-i))
        }
        const_upper <- c(const_upper, const_1)
    }
    #print(const)
    
    ## Factor change constraints, smaller than 1 and greater than -1
    factor_change_a <- numeric()
    for(i in 1:row_p){
        factor_change_a_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), -1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_a <- c(factor_change_a, factor_change_a_1)
    }
    
    ## The sum of the positive and negative part is not greater than 1
    factor_change_b <- numeric()
    for(i in 1:row_p){
        factor_change_b_1 <- c(rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,i-1), 1, 
                               rep(0,row_p-i), rep(0,2*col_p))
        factor_change_b <- c(factor_change_b, factor_change_b_1)
    }
    #print(factor_change_b)
    
    ## Constraint on cost
    
    cost_con <- c(cost, rep(0, 2*col_p))
    
    
    f.con <- matrix(c(const_lower, const_upper, factor_change_b, cost_con), 
                    ncol=(2 * row_p + 2 * col_p), byrow=TRUE)
    print(f.con)
    ## Direction of constraints
    
    f.dir <- c(rep("<=",col_p), rep(">=",col_p), rep("<=", row_p), "<=")
    
    # The right sides of constraints
    
    f.rhs <- c(rep(0,col_p), rep(0,col_p), rep(1, row_p), B)
    
    solution1 <- lp ("max", f.obj, f.con, f.dir, f.rhs, int.vec = c(1:(2*row_p)))
    
    solution1$solution
    solution1$solution[1:row_p] - solution1$solution[(row_p+1):(2*row_p)]
    #solution1
    #const
}


