(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    162960,       3803]
NotebookOptionsPosition[    160158,       3705]
NotebookOutlinePosition[    160844,       3728]
CellTagsIndexPosition[    160801,       3725]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Goal-programming optimization problems for tuning \
paper machines.",
 FontWeight->"Plain"]], "Title",
 CellChangeTimes->{{3.5590230943117676`*^9, 3.5590230965737715`*^9}, {
  3.665120144518697*^9, 3.665120155908713*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["It is important, for the optimization problem to run, \
to define\n\t- all the weights of the characteristics\n\t- the partition of \
the characteristics \n(Later on in this script, it will be possible to define \
them)",
 FontWeight->"Plain"]], "Section",
 CellChangeTimes->{{3.665120172488736*^9, 3.6651201978887715`*^9}, {
  3.6651202615870657`*^9, 3.6651203160971417`*^9}, {3.665120361957206*^9, 
  3.6651203632072077`*^9}, {3.665120505387407*^9, 3.665120511017415*^9}, {
  3.6715068535053*^9, 3.671506868065325*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["It is time to define the number of ",
  FontWeight->"Plain"],
 StyleBox["production factors",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" (fac) and ",
  FontWeight->"Plain"],
 StyleBox["characteristics of the output",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" (char)",
  FontWeight->"Plain"]
}], "Subsection",
 CellChangeTimes->{{3.559019235690238*^9, 3.5590193061318207`*^9}, 
   3.559034460243018*^9, {3.665120371227219*^9, 3.665120441147317*^9}, {
   3.671506878102842*^9, 3.6715068783753424`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fac", "=", "24"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"char", "=", "17"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5588593762179503`*^9, 3.558859441850318*^9}, {
   3.558859487083466*^9, 3.5588594935740776`*^9}, {3.558859584166037*^9, 
   3.558859608157071*^9}, {3.5588596425971193`*^9, 3.558859680067751*^9}, {
   3.558860021743376*^9, 3.5588600226933765`*^9}, 3.5588607634526973`*^9, {
   3.558863077656062*^9, 3.5588630795831723`*^9}, {3.5588648534106293`*^9, 
   3.5588648544656897`*^9}, {3.5588655970012417`*^9, 3.558865598526329*^9}, {
   3.5588658005698853`*^9, 3.558865802192978*^9}, {3.5588658830966053`*^9, 
   3.558865883791645*^9}, {3.5588662505140676`*^9, 3.5588662524941807`*^9}, {
   3.5588668051042147`*^9, 3.558866807204218*^9}, 3.558866902890353*^9, {
   3.5588676184407415`*^9, 3.5588676206598682`*^9}, {3.558867901569936*^9, 
   3.5588679035520487`*^9}, {3.5588707329795537`*^9, 
   3.5588707475063844`*^9}, {3.5588717826735926`*^9, 3.558871783723653*^9}, {
   3.558872851184708*^9, 3.558872853236825*^9}, {3.559019200270194*^9, 
   3.5590192260015893`*^9}, {3.559019263302663*^9, 3.559019263607667*^9}, {
   3.559021590126551*^9, 3.5590216010163703`*^9}, {3.559023049507489*^9, 
   3.5590230516290927`*^9}, {3.5590289191836743`*^9, 
   3.5590289217264786`*^9}, {3.5590290273250647`*^9, 
   3.5590290296494684`*^9}, {3.559032017658187*^9, 3.559032019951391*^9}, {
   3.559032134204014*^9, 3.559032135249216*^9}, {3.5590321762646885`*^9, 
   3.5590321773722897`*^9}, {3.559032367611426*^9, 3.5590323686254272`*^9}, {
   3.55903256994337*^9, 3.5590325717685733`*^9}, {3.559032649923318*^9, 
   3.55903265118692*^9}, {3.5590329411296916`*^9, 3.559032941205696*^9}, 
   3.559034136868726*^9, {3.5590342141508346`*^9, 3.5590342143808346`*^9}, {
   3.559034508207762*^9, 3.5590345084377747`*^9}, 3.5590345811609344`*^9, {
   3.5590426972477455`*^9, 3.55904269732475*^9}, {3.5592868870854235`*^9, 
   3.5592868873194237`*^9}, {3.5592871768255453`*^9, 
   3.5592872274486346`*^9}, {3.55928730446797*^9, 3.559287322705402*^9}, {
   3.559631007946911*^9, 3.559631022348735*^9}, {3.5878974549027233`*^9, 
   3.5878974570927267`*^9}, {3.5879699722672596`*^9, 
   3.5879699740768623`*^9}, {3.6639214581098924`*^9, 
   3.6639214604210243`*^9}, {3.6639225331253796`*^9, 
   3.6639225351174936`*^9}, {3.6639226376763597`*^9, 3.663922639461462*^9}, {
   3.6639226708212557`*^9, 3.66392267265236*^9}, {3.663923146502463*^9, 
   3.6639231482095604`*^9}, {3.663925420986556*^9, 3.663925424082733*^9}, {
   3.66486951750204*^9, 3.6648695211620455`*^9}, {3.6648695653221073`*^9, 
   3.6648695685921116`*^9}, {3.664869604612162*^9, 3.6648696050221624`*^9}, {
   3.6648696433662186`*^9, 3.66486964400622*^9}, 3.665218682101492*^9, {
   3.665218818662303*^9, 3.665218818820312*^9}, {3.665218849845086*^9, 
   3.665218870957294*^9}, {3.6652189314917564`*^9, 3.6652189315637608`*^9}, {
   3.6652190799232464`*^9, 3.665219080803296*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["It is possible to create the relation between factors \
and characteristics in different ways, by commenting and uncommenting the \
following lines:\n- It is possible to import it from a file\n- It is possible \
to generate it randomly\n- It is possible to insert it by hand",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.5590192683637404`*^9, 3.5590193224080706`*^9}, {
   3.6651204744773636`*^9, 3.6651205033974037`*^9}, {3.665120537152483*^9, 
   3.6651205678835263`*^9}, 3.6715069298754263`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"import", " ", "it", " ", "from", " ", "a", " ", "file"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"R", "=", 
     RowBox[{
      RowBox[{"Import", "[", "\"\<\\ontology.xlsx\>\"", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"create", " ", "it", " ", "randomly"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomChoice", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3."}], ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1.", ",", "2.", ",", "3."}], 
        "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "fac"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "char"}], "}"}]}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"insert", " ", "it", " ", "manually"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"R", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "2."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "3.", ",", "0.", ",", "3.", ",", "2.", ",", "1.", ",", "1.", ",", 
         "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "0.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "1.", ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "2."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "1.", ",", "1.", ",",
          "1.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "2."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "0.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "2."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "1.", ",", "1.", ",",
          "1.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "2.", ",", 
         RowBox[{"-", "3."}], ",", 
         RowBox[{"-", "2."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.", ",", 
         RowBox[{"-", "3."}], ",", "2.", ",", 
         RowBox[{"-", "3."}], ",", "0.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "3.", ",", "3.", ",", "3.", ",", "3.", ",",
          "1.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "2."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", 
         "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", 
         "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "0.", ",", "3.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", "0.", ",", "2.", ",",
          "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "2."}], ",", "1.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "1.", ",", "2.", ",", "0.", ",",
          "0.", ",", "2.", ",", "0.", ",", "0.", ",", "0.", ",", "1.", ",", 
         "0.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "0.", ",", "0.", ",",
          "0.", ",", "2.", ",", "0.", ",", "0.", ",", "0.", ",", "2.", ",", 
         "0.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "1.", ",", "0.", ",", "2.", ",",
          "1.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "0.", ",", "0.", ",", "0."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "2."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "0.", ",", "1.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "1.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "1.", ",", "0.", ",", "0.", ",",
          "2.", ",", "0.", ",", "0.", ",", "0.", ",", 
         RowBox[{"-", "1."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", "1.", ",", "1.", ",",
          "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", "1."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "0.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "0.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", 
         RowBox[{"-", "2."}], ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "3.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "2.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", "0.", ",", "2."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "3.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "1.", ",", "0.", ",", "2."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "3.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "1.", ",", "0.", ",", "2."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "0.", ",", 
         RowBox[{"-", "2."}], ",", "3.", ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "2."}], ",", "2.", ",", "2.", ",", 
         RowBox[{"-", "2."}], ",", "0.", ",", "1.", ",", "0.", ",", "2."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", 
         "0.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "0.", ",", "0.", ",", "0."}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", "0.", ",", 
         "0.", ",", "0.", ",", 
         RowBox[{"-", "1."}], ",", 
         RowBox[{"-", "1."}], ",", "1.", ",", "0.", ",", "0.", ",", "0.", ",",
          "0.", ",", "0.", ",", "0."}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "R", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Dimensions", "[", "R", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5590341014459705`*^9, 3.559034113804488*^9}, {
   3.559034171499775*^9, 3.5590342414018726`*^9}, {3.585636796859818*^9, 
   3.5856368004790244`*^9}, {3.5878970536175137`*^9, 3.587897056217517*^9}, {
   3.587897093268569*^9, 3.587897095708573*^9}, {3.5878973910881186`*^9, 
   3.5878973947181234`*^9}, {3.5878974628727345`*^9, 3.5878974652227383`*^9}, 
   3.6639214498154182`*^9, {3.663921491439799*^9, 3.6639215002053003`*^9}, {
   3.6639223698810425`*^9, 3.6639223833758144`*^9}, {3.6639224517207236`*^9, 
   3.6639224584381075`*^9}, {3.663922506015829*^9, 3.6639225245748906`*^9}, {
   3.663925404847633*^9, 3.663925413778144*^9}, {3.6640150334357924`*^9, 
   3.664015046345811*^9}, {3.664017173816654*^9, 3.664017180466664*^9}, {
   3.664019351057068*^9, 3.6640193918233995`*^9}, {3.6640194681757665`*^9, 
   3.6640195160405045`*^9}, 3.6640196186833754`*^9, {3.664019780269617*^9, 
   3.6640197866549826`*^9}, {3.664019831126526*^9, 3.664019833798679*^9}, {
   3.6640199641161327`*^9, 3.6640199679763536`*^9}, 3.6640874835131173`*^9, 
   3.6640924112459106`*^9, 3.6648613925156116`*^9, {3.664861422965655*^9, 
   3.6648614450356855`*^9}, {3.664861618546974*^9, 3.6648616470670147`*^9}, {
   3.6648633846614485`*^9, 3.6648633886114535`*^9}, {3.664863503831615*^9, 
   3.66486351446163*^9}, {3.664869460817958*^9, 3.6648694659479656`*^9}, {
   3.664871857401227*^9, 3.664871917361311*^9}, {3.664872295697118*^9, 
   3.6648723076671343`*^9}, {3.665120574783536*^9, 3.665120581633546*^9}, {
   3.665218668273701*^9, 3.665218678512287*^9}, {3.665219084198491*^9, 
   3.665219093109*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"24", ",", "17"}], "}"}]], "Output",
 CellChangeTimes->{
  3.665120616353594*^9, 3.665122334117264*^9, 3.665127409402691*^9, 
   3.665128342236717*^9, 3.6651349228089066`*^9, {3.6651349638389654`*^9, 
   3.6651349874589987`*^9}, 3.665218688283846*^9, {3.665218829578927*^9, 
   3.665218872525384*^9}, {3.6652189338578916`*^9, 3.6652189621615105`*^9}, 
   3.6652191288740463`*^9, 3.6657383835991573`*^9, 3.6657384503982515`*^9, 
   3.6657386051079717`*^9, 3.665738643733026*^9, {3.66573873851616*^9, 
   3.6657387452571697`*^9}, 3.6657388136347814`*^9, 3.6700391612056475`*^9, {
   3.670039240589761*^9, 3.67003936321194*^9}, 3.670048537324272*^9, 
   3.6705736327741566`*^9, {3.6705736702082977`*^9, 3.670573721674241*^9}, 
   3.6705768032961445`*^9, 3.6715069169004045`*^9, 3.6715069499604588`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["This command plots the heatmap associated with the \
relation.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.5590192683637404`*^9, 3.5590193224080706`*^9}, {
  3.6651204744773636`*^9, 3.6651205033974037`*^9}, {3.665120537152483*^9, 
  3.6651205678835263`*^9}, {3.665120654373647*^9, 3.6651206652936625`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"MatrixPlot", "[", "R", "]"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HoldForm", "[", 
         RowBox[{"Production", "\"\< \>\"", "  ", "factors"}], "]"}], ",", 
        "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"HoldForm", "[", 
         RowBox[{
         "Characteristics", " ", "\"\<\>\"", " ", "of", " ", "\"\<\>\"", " ", 
          "the", " ", "\"\<\>\"", " ", "output"}], "]"}]}], "}"}]}], "}"}]}], 
   ",", 
   RowBox[{"PlotLabel", "\[Rule]", "None"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<PlotR.eps\>\"", ",", "RPlot"}], "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.564144308381631*^9, 3.5641443161816416`*^9}, {
   3.5641444145417795`*^9, 3.5641444201717873`*^9}, {3.56664077189236*^9, 
   3.566640847318493*^9}, {3.5666414911336937`*^9, 3.5666414916736946`*^9}, {
   3.664175626516143*^9, 3.6641756311261497`*^9}, {3.665120632783617*^9, 
   3.6651206360936217`*^9}, {3.665120795323845*^9, 3.665120889243976*^9}, {
   3.665120961814078*^9, 3.6651209640340805`*^9}, {3.6651210212041607`*^9, 
   3.66512102784417*^9}, {3.6651211726629686`*^9, 3.6651211768329744`*^9}, 
   3.665127549434695*^9, {3.6651283300566998`*^9, 3.665128389776784*^9}}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGCQAGJBIAaxIeCD/VClVzOdeCQre9P+2A7N9KkiT+33dvrq
3Gp9iVPc+3JlYYzlW3snT+aunz4v7Tu/JG1Xmn93wP0x3Ghaxwsuc2jtL1zu
DMx74qVYfta+cv/yjPj/9+0XfFsfHq3y2p51GfMrmfbX9rVmfd8/PHxoz+v6
daN4Qw3J6nG5B5c5MPmHVSLr3B/egvIZGHCpJ9U9pPqL1PDEpR6XvaPxMhov
o/FCebyQWj7jcj+1y3P0eKFW/YIrfEitX6gVL9RKV7SuH0kN/4Gq96llPqni
o/FCn3ihVr4g1XxahwOp4tRKP6TSpJar1DKHWvUmqemfWuFPaviQSlOrXCI1
3KiVX0i1l1ruITVdUSu/D7Z4IbVdN9TjhdR6hFrhQOvwHKh+HLHlFLk0tdo5
pJo/UPUyresLapmPK9xILU9ILQ9JTbfU8i+t42Wg2xuU9rupFY+09i+p5dhA
lXujNH1p9PSvJd+06uLqC/ZJAhGWW05cs78trLJtd/sbnOkNl3pc9pE7boDu
TmqJU6veJ1U9tcKT1u1YarUTqCVOrXYvrnDGFZ7Uihdc6mkd/tQaR6JW+5DU
cQ9axwu18sVgyy/UKpeoNU9Eqr20HhcdqPJqoOoXmDyu+hEXja6e1P4ItcKN
1uMMAzUvQOv6glrlHq3Hmak1vkGt/AgALV5FwA==
   "], {{0, 0}, {17, 24}}, {0, 1}],
  Frame->True,
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Production", " ", "\" \"", " ", "factors"}], HoldForm], 
      TraditionalForm], None}, {None, 
     FormBox[
      TagBox[
       RowBox[{
        "Characteristics", " ", "\"\"", " ", "of", " ", "\"\"", " ", "the", 
         " ", "\"\"", " ", "output"}], HoldForm], TraditionalForm]}},
  FrameTicks->{{{{23.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["5", TraditionalForm]}, {14.5, 
       FormBox["10", TraditionalForm]}, {9.5, 
       FormBox["15", TraditionalForm]}, {4.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["24", TraditionalForm]}}, {{23.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["5", TraditionalForm]}, {14.5, 
       FormBox["10", TraditionalForm]}, {9.5, 
       FormBox["15", TraditionalForm]}, {4.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["24", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {16.5, 
       FormBox["17", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {16.5, 
       FormBox["17", TraditionalForm]}}}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultPlotStyle" -> Automatic, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05]},
  PlotLabel->None]], "Output",
 CellChangeTimes->{{3.665120884243969*^9, 3.665120889713977*^9}, {
   3.6651209522240644`*^9, 3.665120964974082*^9}, 3.665121028374171*^9, 
   3.6651223341572638`*^9, 3.6651274118108287`*^9, 3.665127550445752*^9, {
   3.6651283466967235`*^9, 3.6651283904767847`*^9}, 3.665134922948907*^9, {
   3.6651349638889656`*^9, 3.6651349874989986`*^9}, 3.6652186931471243`*^9, {
   3.6652188331891336`*^9, 3.6652188725743866`*^9}, {3.665218933914895*^9, 
   3.665218962217514*^9}, 3.6652191289220486`*^9, 3.6657383871801624`*^9, 
   3.6657384504782515`*^9, 3.6657386051579714`*^9, 3.665738643773026*^9, {
   3.66573873855616*^9, 3.66573874530717*^9}, 3.6657388136747813`*^9, 
   3.670039164615652*^9, {3.6700392406297607`*^9, 3.67003936326194*^9}, 
   3.6700485376317763`*^9, 3.6705736330551724`*^9, {3.6705736702623005`*^9, 
   3.6705737217202435`*^9}, 3.6705768033361454`*^9, 3.671506917212905*^9, 
   3.6715069500004587`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Define the vector of minus deviations, plus \
deviations and the variables",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.5590192683637404`*^9, 3.5590193642047124`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["d", "+"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubsuperscriptBox["d", "j", "+"], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "char"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   SubscriptBox["d", "+"], "]"}], ";", 
  SubscriptBox["d", "+"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["d", "-"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubsuperscriptBox["d", "j", "-"], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "char"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   SubscriptBox["d", "-"], "]"}], ";", 
  SubscriptBox["d", "-"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["x", "\[RightVector]"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "fac"}], "}"}]}], "]"}]}], ";", " ", 
  OverscriptBox["x", "\[RightVector]"]}]}], "Input",
 CellChangeTimes->{{3.5588596886962447`*^9, 3.5588598246170187`*^9}, {
   3.558859872136737*^9, 3.5588598890151987`*^9}, {3.558859939260869*^9, 
   3.558860015773367*^9}, {3.558860097591751*^9, 3.5588601125016036`*^9}, {
   3.5588613633130074`*^9, 3.5588613954148436`*^9}, {3.5588624035315046`*^9, 
   3.558862406129653*^9}, {3.5588656171363935`*^9, 3.5588656449229827`*^9}, {
   3.5588717881979084`*^9, 3.5588718009226365`*^9}, 3.5588718603490353`*^9, {
   3.559019368477278*^9, 3.55901939724122*^9}, {3.6640149162456284`*^9, 
   3.664014987845729*^9}, {3.66401711321657*^9, 3.6640171174565754`*^9}, {
   3.6651212231330395`*^9, 3.6651212354630566`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "1"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "2"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "3"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "4"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "5"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "6"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "7"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "8"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "9"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "10"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "11"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "12"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "13"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "14"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "15"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "16"], ")"}], "+"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "17"], ")"}], "+"]}], "}"}]], "Output",
 CellChangeTimes->{{3.5588598153044863`*^9, 3.5588598249040356`*^9}, {
   3.5588598671424513`*^9, 3.558860023983379*^9}, {3.5588601087183876`*^9, 
   3.558860112891626*^9}, 3.5588607668128896`*^9, 3.5588613961488857`*^9, 
   3.558861678708047*^9, 3.558862407425727*^9, 3.5588630828943615`*^9, 
   3.5588648584589186`*^9, {3.558865601541501*^9, 3.5588656553185773`*^9}, 
   3.5588658057321806`*^9, 3.5588658860177727`*^9, 3.5588662420015807`*^9, 
   3.558866280719795*^9, 3.5588668143572283`*^9, {3.5588668970403447`*^9, 
   3.558866904950356*^9}, {3.558867624273075*^9, 3.558867653816765*^9}, 
   3.5588677291590743`*^9, {3.5588678949445567`*^9, 3.5588679053801537`*^9}, 
   3.558870757062931*^9, 3.5588718647722883`*^9, 3.558872863566416*^9, {
   3.559019383213505*^9, 3.559019398006232*^9}, 3.5590210100948815`*^9, {
   3.5590215857741437`*^9, 3.5590216038867755`*^9}, 3.5590230571515026`*^9, 
   3.5590231111139975`*^9, 3.559026331363573*^9, {3.5590263781049547`*^9, 
   3.5590264024887977`*^9}, 3.559026499289968*^9, 3.559029035327879*^9, 
   3.559029842531974*^9, 3.5590320501560445`*^9, 3.5590320990787306`*^9, 
   3.559032152315646*^9, 3.559032268598651*^9, 3.559032316882736*^9, 
   3.5590323708250313`*^9, 3.5590324662537184`*^9, 3.559032574365178*^9, 
   3.5590326693765526`*^9, 3.5590342451218777`*^9, 3.5590344662443614`*^9, 
   3.559034511289938*^9, 3.5590345837230806`*^9, 3.559042311236761*^9, 
   3.5590427005379333`*^9, 3.559042779793922*^9, 3.5592868217037086`*^9, 
   3.5592868905174294`*^9, {3.5592871806631527`*^9, 3.559287231161441*^9}, {
   3.5592873084771767`*^9, 3.5592873262310085`*^9}, 3.5592987330267324`*^9, 
   3.5592995035223885`*^9, 3.559301158545202*^9, 3.5595558789627323`*^9, 
   3.559627297358678*^9, 3.5596309364688225`*^9, 3.5596310284610844`*^9, 
   3.559900363301157*^9, 3.559902073148368*^9, 3.5599034283830624`*^9, 
   3.5599037317974167`*^9, 3.5666410005508375`*^9, 3.5734604164716215`*^9, {
   3.5734605069268723`*^9, 3.5734605263768997`*^9}, 3.579320026744349*^9, 
   3.5797038353415194`*^9, 3.5797042585851555`*^9, 3.579704297065209*^9, 
   3.5797099774203634`*^9, {3.5797100548034716`*^9, 3.579710072813497*^9}, 
   3.579710152023608*^9, 3.579710219863703*^9, 3.579710622580906*^9, 
   3.57978187178378*^9, 3.5797850321480656`*^9, 3.5797866210255756`*^9, 
   3.5856367582185497`*^9, {3.585636806032634*^9, 3.585636827077071*^9}, 
   3.587897062968527*^9, 3.58789710101858*^9, 3.587897406048139*^9, 
   3.587897468922743*^9, 3.587897519641815*^9, {3.5878975550138645`*^9, 
   3.587897583795907*^9}, 3.5879699796148725`*^9, 3.587970013532832*^9, 
   3.5879700446754866`*^9, 3.5879717177581973`*^9, 3.58797223899905*^9, 
   3.5879734929643145`*^9, {3.6635015534225683`*^9, 3.6635015797086334`*^9}, 
   3.6635016274207015`*^9, 3.6635016858209105`*^9, 3.6639214630311737`*^9, 
   3.6639215030604634`*^9, {3.6639215425397215`*^9, 3.663921584740135*^9}, 
   3.6639216816066756`*^9, 3.663922018324935*^9, 3.6639222121440206`*^9, {
   3.663922246609992*^9, 3.6639222656950836`*^9}, 3.663922537607636*^9, 
   3.663922641590584*^9, 3.6639226750534973`*^9, 3.6639231539308877`*^9, 
   3.663923187993836*^9, {3.6639253605721006`*^9, 3.6639253852435117`*^9}, 
   3.663925473097536*^9, {3.66392560778024*^9, 3.663925627943393*^9}, {
   3.6639303313014097`*^9, 3.663930349033424*^9}, 3.6639304100419135`*^9, 
   3.6640143512497644`*^9, {3.664014906655615*^9, 3.664015012915764*^9}, 
   3.6640150502658157`*^9, 3.6640152131170473`*^9, 3.6640155826919813`*^9, 
   3.66401563177205*^9, 3.664015690942133*^9, 3.664016121017334*^9, 
   3.6640165425506754`*^9, 3.6640165967927523`*^9, 3.6640167314539413`*^9, {
   3.6640171140365705`*^9, 3.6640171179565763`*^9}, 3.6640193984167767`*^9, 
   3.664019439442123*^9, 3.66401964044662*^9, {3.664019673196493*^9, 
   3.664019698727953*^9}, {3.664019872712905*^9, 3.6640198871617312`*^9}, 
   3.664087534123188*^9, {3.6640875681107683`*^9, 3.664087608760825*^9}, {
   3.664087652821887*^9, 3.6640876693119097`*^9}, 3.6648615387748613`*^9, 
   3.664861595726942*^9, 3.6648632532692633`*^9, 3.6648632972793245`*^9, 
   3.664863445401533*^9, 3.664863487131592*^9, {3.664868997041279*^9, 
   3.6648690247503233`*^9}, 3.664869472099975*^9, 3.6648695264320526`*^9, 
   3.6648695749721203`*^9, {3.6648696100221696`*^9, 3.6648696488562264`*^9}, 
   3.6648719505113573`*^9, 3.6648723153971453`*^9, 3.665121192532996*^9, 
   3.665121236373058*^9, 3.6651223341772633`*^9, 3.6651349229689074`*^9, {
   3.6651349639289656`*^9, 3.6651349875189986`*^9}, 3.665218697990401*^9, {
   3.6652188332081347`*^9, 3.6652188725903873`*^9}, {3.6652189339368963`*^9, 
   3.6652189622395153`*^9}, 3.6652191289390497`*^9, 3.6657383896901655`*^9, 
   3.665738450498251*^9, 3.665738605177972*^9, 3.665738643793026*^9, {
   3.66573873857616*^9, 3.6657387453371696`*^9}, 3.6657388136947813`*^9, 
   3.6700391769756694`*^9, {3.6700392406697607`*^9, 3.67003936328194*^9}, 
   3.670048537676777*^9, 3.6705736330731735`*^9, {3.6705736702793016`*^9, 
   3.670573721736245*^9}, 3.6705768033511453`*^9, 3.671506917232905*^9, 
   3.6715069500304585`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "1"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "2"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "3"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "4"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "5"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "6"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "7"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "8"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "9"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "10"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "11"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "12"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "13"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "14"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "15"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "16"], ")"}], "-"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "17"], ")"}], "-"]}], "}"}]], "Output",
 CellChangeTimes->{{3.5588598153044863`*^9, 3.5588598249040356`*^9}, {
   3.5588598671424513`*^9, 3.558860023983379*^9}, {3.5588601087183876`*^9, 
   3.558860112891626*^9}, 3.5588607668128896`*^9, 3.5588613961488857`*^9, 
   3.558861678708047*^9, 3.558862407425727*^9, 3.5588630828943615`*^9, 
   3.5588648584589186`*^9, {3.558865601541501*^9, 3.5588656553185773`*^9}, 
   3.5588658057321806`*^9, 3.5588658860177727`*^9, 3.5588662420015807`*^9, 
   3.558866280719795*^9, 3.5588668143572283`*^9, {3.5588668970403447`*^9, 
   3.558866904950356*^9}, {3.558867624273075*^9, 3.558867653816765*^9}, 
   3.5588677291590743`*^9, {3.5588678949445567`*^9, 3.5588679053801537`*^9}, 
   3.558870757062931*^9, 3.5588718647722883`*^9, 3.558872863566416*^9, {
   3.559019383213505*^9, 3.559019398006232*^9}, 3.5590210100948815`*^9, {
   3.5590215857741437`*^9, 3.5590216038867755`*^9}, 3.5590230571515026`*^9, 
   3.5590231111139975`*^9, 3.559026331363573*^9, {3.5590263781049547`*^9, 
   3.5590264024887977`*^9}, 3.559026499289968*^9, 3.559029035327879*^9, 
   3.559029842531974*^9, 3.5590320501560445`*^9, 3.5590320990787306`*^9, 
   3.559032152315646*^9, 3.559032268598651*^9, 3.559032316882736*^9, 
   3.5590323708250313`*^9, 3.5590324662537184`*^9, 3.559032574365178*^9, 
   3.5590326693765526`*^9, 3.5590342451218777`*^9, 3.5590344662443614`*^9, 
   3.559034511289938*^9, 3.5590345837230806`*^9, 3.559042311236761*^9, 
   3.5590427005379333`*^9, 3.559042779793922*^9, 3.5592868217037086`*^9, 
   3.5592868905174294`*^9, {3.5592871806631527`*^9, 3.559287231161441*^9}, {
   3.5592873084771767`*^9, 3.5592873262310085`*^9}, 3.5592987330267324`*^9, 
   3.5592995035223885`*^9, 3.559301158545202*^9, 3.5595558789627323`*^9, 
   3.559627297358678*^9, 3.5596309364688225`*^9, 3.5596310284610844`*^9, 
   3.559900363301157*^9, 3.559902073148368*^9, 3.5599034283830624`*^9, 
   3.5599037317974167`*^9, 3.5666410005508375`*^9, 3.5734604164716215`*^9, {
   3.5734605069268723`*^9, 3.5734605263768997`*^9}, 3.579320026744349*^9, 
   3.5797038353415194`*^9, 3.5797042585851555`*^9, 3.579704297065209*^9, 
   3.5797099774203634`*^9, {3.5797100548034716`*^9, 3.579710072813497*^9}, 
   3.579710152023608*^9, 3.579710219863703*^9, 3.579710622580906*^9, 
   3.57978187178378*^9, 3.5797850321480656`*^9, 3.5797866210255756`*^9, 
   3.5856367582185497`*^9, {3.585636806032634*^9, 3.585636827077071*^9}, 
   3.587897062968527*^9, 3.58789710101858*^9, 3.587897406048139*^9, 
   3.587897468922743*^9, 3.587897519641815*^9, {3.5878975550138645`*^9, 
   3.587897583795907*^9}, 3.5879699796148725`*^9, 3.587970013532832*^9, 
   3.5879700446754866`*^9, 3.5879717177581973`*^9, 3.58797223899905*^9, 
   3.5879734929643145`*^9, {3.6635015534225683`*^9, 3.6635015797086334`*^9}, 
   3.6635016274207015`*^9, 3.6635016858209105`*^9, 3.6639214630311737`*^9, 
   3.6639215030604634`*^9, {3.6639215425397215`*^9, 3.663921584740135*^9}, 
   3.6639216816066756`*^9, 3.663922018324935*^9, 3.6639222121440206`*^9, {
   3.663922246609992*^9, 3.6639222656950836`*^9}, 3.663922537607636*^9, 
   3.663922641590584*^9, 3.6639226750534973`*^9, 3.6639231539308877`*^9, 
   3.663923187993836*^9, {3.6639253605721006`*^9, 3.6639253852435117`*^9}, 
   3.663925473097536*^9, {3.66392560778024*^9, 3.663925627943393*^9}, {
   3.6639303313014097`*^9, 3.663930349033424*^9}, 3.6639304100419135`*^9, 
   3.6640143512497644`*^9, {3.664014906655615*^9, 3.664015012915764*^9}, 
   3.6640150502658157`*^9, 3.6640152131170473`*^9, 3.6640155826919813`*^9, 
   3.66401563177205*^9, 3.664015690942133*^9, 3.664016121017334*^9, 
   3.6640165425506754`*^9, 3.6640165967927523`*^9, 3.6640167314539413`*^9, {
   3.6640171140365705`*^9, 3.6640171179565763`*^9}, 3.6640193984167767`*^9, 
   3.664019439442123*^9, 3.66401964044662*^9, {3.664019673196493*^9, 
   3.664019698727953*^9}, {3.664019872712905*^9, 3.6640198871617312`*^9}, 
   3.664087534123188*^9, {3.6640875681107683`*^9, 3.664087608760825*^9}, {
   3.664087652821887*^9, 3.6640876693119097`*^9}, 3.6648615387748613`*^9, 
   3.664861595726942*^9, 3.6648632532692633`*^9, 3.6648632972793245`*^9, 
   3.664863445401533*^9, 3.664863487131592*^9, {3.664868997041279*^9, 
   3.6648690247503233`*^9}, 3.664869472099975*^9, 3.6648695264320526`*^9, 
   3.6648695749721203`*^9, {3.6648696100221696`*^9, 3.6648696488562264`*^9}, 
   3.6648719505113573`*^9, 3.6648723153971453`*^9, 3.665121192532996*^9, 
   3.665121236373058*^9, 3.6651223341772633`*^9, 3.6651349229689074`*^9, {
   3.6651349639289656`*^9, 3.6651349875189986`*^9}, 3.665218697990401*^9, {
   3.6652188332081347`*^9, 3.6652188725903873`*^9}, {3.6652189339368963`*^9, 
   3.6652189622395153`*^9}, 3.6652191289390497`*^9, 3.6657383896901655`*^9, 
   3.665738450498251*^9, 3.665738605177972*^9, 3.665738643793026*^9, {
   3.66573873857616*^9, 3.6657387453371696`*^9}, 3.6657388136947813`*^9, 
   3.6700391769756694`*^9, {3.6700392406697607`*^9, 3.67003936328194*^9}, 
   3.670048537676777*^9, 3.6705736330731735`*^9, {3.6705736702793016`*^9, 
   3.670573721736245*^9}, 3.6705768033511453`*^9, 3.671506917232905*^9, 
   3.6715069500304585`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "6"], ",", 
   SubscriptBox["x", "7"], ",", 
   SubscriptBox["x", "8"], ",", 
   SubscriptBox["x", "9"], ",", 
   SubscriptBox["x", "10"], ",", 
   SubscriptBox["x", "11"], ",", 
   SubscriptBox["x", "12"], ",", 
   SubscriptBox["x", "13"], ",", 
   SubscriptBox["x", "14"], ",", 
   SubscriptBox["x", "15"], ",", 
   SubscriptBox["x", "16"], ",", 
   SubscriptBox["x", "17"], ",", 
   SubscriptBox["x", "18"], ",", 
   SubscriptBox["x", "19"], ",", 
   SubscriptBox["x", "20"], ",", 
   SubscriptBox["x", "21"], ",", 
   SubscriptBox["x", "22"], ",", 
   SubscriptBox["x", "23"], ",", 
   SubscriptBox["x", "24"]}], "}"}]], "Output",
 CellChangeTimes->{{3.5588598153044863`*^9, 3.5588598249040356`*^9}, {
   3.5588598671424513`*^9, 3.558860023983379*^9}, {3.5588601087183876`*^9, 
   3.558860112891626*^9}, 3.5588607668128896`*^9, 3.5588613961488857`*^9, 
   3.558861678708047*^9, 3.558862407425727*^9, 3.5588630828943615`*^9, 
   3.5588648584589186`*^9, {3.558865601541501*^9, 3.5588656553185773`*^9}, 
   3.5588658057321806`*^9, 3.5588658860177727`*^9, 3.5588662420015807`*^9, 
   3.558866280719795*^9, 3.5588668143572283`*^9, {3.5588668970403447`*^9, 
   3.558866904950356*^9}, {3.558867624273075*^9, 3.558867653816765*^9}, 
   3.5588677291590743`*^9, {3.5588678949445567`*^9, 3.5588679053801537`*^9}, 
   3.558870757062931*^9, 3.5588718647722883`*^9, 3.558872863566416*^9, {
   3.559019383213505*^9, 3.559019398006232*^9}, 3.5590210100948815`*^9, {
   3.5590215857741437`*^9, 3.5590216038867755`*^9}, 3.5590230571515026`*^9, 
   3.5590231111139975`*^9, 3.559026331363573*^9, {3.5590263781049547`*^9, 
   3.5590264024887977`*^9}, 3.559026499289968*^9, 3.559029035327879*^9, 
   3.559029842531974*^9, 3.5590320501560445`*^9, 3.5590320990787306`*^9, 
   3.559032152315646*^9, 3.559032268598651*^9, 3.559032316882736*^9, 
   3.5590323708250313`*^9, 3.5590324662537184`*^9, 3.559032574365178*^9, 
   3.5590326693765526`*^9, 3.5590342451218777`*^9, 3.5590344662443614`*^9, 
   3.559034511289938*^9, 3.5590345837230806`*^9, 3.559042311236761*^9, 
   3.5590427005379333`*^9, 3.559042779793922*^9, 3.5592868217037086`*^9, 
   3.5592868905174294`*^9, {3.5592871806631527`*^9, 3.559287231161441*^9}, {
   3.5592873084771767`*^9, 3.5592873262310085`*^9}, 3.5592987330267324`*^9, 
   3.5592995035223885`*^9, 3.559301158545202*^9, 3.5595558789627323`*^9, 
   3.559627297358678*^9, 3.5596309364688225`*^9, 3.5596310284610844`*^9, 
   3.559900363301157*^9, 3.559902073148368*^9, 3.5599034283830624`*^9, 
   3.5599037317974167`*^9, 3.5666410005508375`*^9, 3.5734604164716215`*^9, {
   3.5734605069268723`*^9, 3.5734605263768997`*^9}, 3.579320026744349*^9, 
   3.5797038353415194`*^9, 3.5797042585851555`*^9, 3.579704297065209*^9, 
   3.5797099774203634`*^9, {3.5797100548034716`*^9, 3.579710072813497*^9}, 
   3.579710152023608*^9, 3.579710219863703*^9, 3.579710622580906*^9, 
   3.57978187178378*^9, 3.5797850321480656`*^9, 3.5797866210255756`*^9, 
   3.5856367582185497`*^9, {3.585636806032634*^9, 3.585636827077071*^9}, 
   3.587897062968527*^9, 3.58789710101858*^9, 3.587897406048139*^9, 
   3.587897468922743*^9, 3.587897519641815*^9, {3.5878975550138645`*^9, 
   3.587897583795907*^9}, 3.5879699796148725`*^9, 3.587970013532832*^9, 
   3.5879700446754866`*^9, 3.5879717177581973`*^9, 3.58797223899905*^9, 
   3.5879734929643145`*^9, {3.6635015534225683`*^9, 3.6635015797086334`*^9}, 
   3.6635016274207015`*^9, 3.6635016858209105`*^9, 3.6639214630311737`*^9, 
   3.6639215030604634`*^9, {3.6639215425397215`*^9, 3.663921584740135*^9}, 
   3.6639216816066756`*^9, 3.663922018324935*^9, 3.6639222121440206`*^9, {
   3.663922246609992*^9, 3.6639222656950836`*^9}, 3.663922537607636*^9, 
   3.663922641590584*^9, 3.6639226750534973`*^9, 3.6639231539308877`*^9, 
   3.663923187993836*^9, {3.6639253605721006`*^9, 3.6639253852435117`*^9}, 
   3.663925473097536*^9, {3.66392560778024*^9, 3.663925627943393*^9}, {
   3.6639303313014097`*^9, 3.663930349033424*^9}, 3.6639304100419135`*^9, 
   3.6640143512497644`*^9, {3.664014906655615*^9, 3.664015012915764*^9}, 
   3.6640150502658157`*^9, 3.6640152131170473`*^9, 3.6640155826919813`*^9, 
   3.66401563177205*^9, 3.664015690942133*^9, 3.664016121017334*^9, 
   3.6640165425506754`*^9, 3.6640165967927523`*^9, 3.6640167314539413`*^9, {
   3.6640171140365705`*^9, 3.6640171179565763`*^9}, 3.6640193984167767`*^9, 
   3.664019439442123*^9, 3.66401964044662*^9, {3.664019673196493*^9, 
   3.664019698727953*^9}, {3.664019872712905*^9, 3.6640198871617312`*^9}, 
   3.664087534123188*^9, {3.6640875681107683`*^9, 3.664087608760825*^9}, {
   3.664087652821887*^9, 3.6640876693119097`*^9}, 3.6648615387748613`*^9, 
   3.664861595726942*^9, 3.6648632532692633`*^9, 3.6648632972793245`*^9, 
   3.664863445401533*^9, 3.664863487131592*^9, {3.664868997041279*^9, 
   3.6648690247503233`*^9}, 3.664869472099975*^9, 3.6648695264320526`*^9, 
   3.6648695749721203`*^9, {3.6648696100221696`*^9, 3.6648696488562264`*^9}, 
   3.6648719505113573`*^9, 3.6648723153971453`*^9, 3.665121192532996*^9, 
   3.665121236373058*^9, 3.6651223341772633`*^9, 3.6651349229689074`*^9, {
   3.6651349639289656`*^9, 3.6651349875189986`*^9}, 3.665218697990401*^9, {
   3.6652188332081347`*^9, 3.6652188725903873`*^9}, {3.6652189339368963`*^9, 
   3.6652189622395153`*^9}, 3.6652191289390497`*^9, 3.6657383896901655`*^9, 
   3.665738450498251*^9, 3.665738605177972*^9, 3.665738643793026*^9, {
   3.66573873857616*^9, 3.6657387453371696`*^9}, 3.6657388136947813`*^9, 
   3.6700391769756694`*^9, {3.6700392406697607`*^9, 3.67003936328194*^9}, 
   3.670048537676777*^9, 3.6705736330731735`*^9, {3.6705736702793016`*^9, 
   3.670573721736245*^9}, 3.6705768033511453`*^9, 3.671506917232905*^9, 
   3.6715069500404587`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["This is where the engineer can specify the partition \
of the charactersitics and how he wants to change the status quo. The buttons \
can be used to specify it.\nRemember that the special case of being satisfied \
with the status quo is equivalent to specify \[OpenCurlyDoubleQuote]unchanged\
\[CloseCurlyDoubleQuote] for all the charactersitics.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
  3.5590205880227747`*^9, 3.5590205933267837`*^9}, {3.5590206282084446`*^9, 
  3.5590206483958807`*^9}, {3.6651212616530933`*^9, 3.6651213776932554`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", "=", "i"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\"\<c\>\"", "i"], ",", 
        RowBox[{"SetterBar", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", 
           SubscriptBox["z", "i"], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], "\[Rule]", 
             "\"\< increase \>\""}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], "\[Rule]", 
             "\"\< decrease \>\""}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], "\[Rule]", 
             "\"\< unchanged \>\""}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], "\[Rule]", "\"\< free \>\""}]}],
            "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CPART", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["z", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"Transpose", "[", "CPART", "]"}], "]"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["\[Theta]", "+"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"CPART", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["\[Theta]", "-"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"CPART", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.558860538795848*^9, 3.5588605457462454`*^9}, {
   3.5588606097759075`*^9, 3.5588606460699835`*^9}, {3.558860692450636*^9, 
   3.558860694601759*^9}, 3.5588607569853277`*^9, {3.5588607876880836`*^9, 
   3.5588608038400073`*^9}, 3.558861811203625*^9, {3.5588618851488547`*^9, 
   3.5588618866349397`*^9}, {3.558861927984305*^9, 3.5588619898338423`*^9}, {
   3.5588620456040325`*^9, 3.558862084099234*^9}, {3.558864861719105*^9, 
   3.5588648854454618`*^9}, {3.558865679823979*^9, 3.5588657065275064`*^9}, {
   3.558865813447622*^9, 3.5588658204860244`*^9}, {3.5588658942562437`*^9, 
   3.5588659267604103`*^9}, {3.558866135110012*^9, 3.558866137270015*^9}, {
   3.55886625842852*^9, 3.558866273421378*^9}, {3.5588663626294804`*^9, 
   3.5588663684368124`*^9}, 3.5588665271734695`*^9, {3.5588668215572386`*^9, 
   3.5588668805903215`*^9}, {3.5588669115503654`*^9, 
   3.5588669270103865`*^9}, {3.5588676080011444`*^9, 3.55886761141634*^9}, {
   3.5588677403197126`*^9, 3.5588677456110153`*^9}, {3.558867775895747*^9, 
   3.5588677971009607`*^9}, {3.558871882575307*^9, 3.558871884854437*^9}, {
   3.559020411130212*^9, 3.559020413997756*^9}, {3.5590230656223173`*^9, 
   3.5590230783519397`*^9}, {3.5590289380597076`*^9, 
   3.5590290205702524`*^9}, {3.5590320385466237`*^9, 
   3.5590320425100307`*^9}, {3.5590321386656218`*^9, 3.559032140646826*^9}, {
   3.5590321803986955`*^9, 3.559032183503101*^9}, 3.5590323034199123`*^9, {
   3.559032358079809*^9, 3.559032362447817*^9}, {3.559032461901311*^9, 
   3.5590324634925137`*^9}, {3.559032553344941*^9, 3.559032556761347*^9}, {
   3.5590326553677273`*^9, 3.5590326586593337`*^9}, {3.559034286372936*^9, 
   3.5590342942829466`*^9}, {3.559042536182584*^9, 3.5590425381825867`*^9}, {
   3.559042570021468*^9, 3.5590426560983915`*^9}, {3.55929717184568*^9, 
   3.5592971825316987`*^9}, {3.559298723236719*^9, 3.5592987284867263`*^9}, {
   3.559555885131085*^9, 3.559555893973591*^9}, {3.5596273060501747`*^9, 
   3.559627352227816*^9}, {3.559631108263649*^9, 3.559631118615241*^9}, {
   3.5599003729921703`*^9, 3.559900405682216*^9}, {3.5599016051791553`*^9, 
   3.559901607209158*^9}, {3.559901841625741*^9, 3.5599018502177534`*^9}, {
   3.5599020920793943`*^9, 3.5599020984294033`*^9}, {3.559903640504195*^9, 
   3.5599036502827544`*^9}, {3.559903717989627*^9, 3.5599037266431217`*^9}, {
   3.559903999454726*^9, 3.5599040245861635`*^9}, {3.573460520866892*^9, 
   3.573460523256895*^9}, {3.5797042187810993`*^9, 3.579704229461114*^9}, {
   3.579710048131462*^9, 3.5797100512914667`*^9}, {3.579710212793693*^9, 
   3.5797102145736957`*^9}, {3.5878975463738527`*^9, 
   3.5878975499438577`*^9}, {3.58796998972369*^9, 3.587969996073901*^9}, 
   3.663921561232791*^9, {3.663921667907892*^9, 3.6639216732121954`*^9}, {
   3.663922566821307*^9, 3.6639225708775387`*^9}, {3.6639226537572794`*^9, 
   3.6639226604856644`*^9}, {3.663923170067811*^9, 3.6639231724579477`*^9}, {
   3.663925443369836*^9, 3.66392546127386*^9}, {3.6639255775485106`*^9, 
   3.663925599681777*^9}, {3.6639303447191772`*^9, 3.663930346326269*^9}, {
   3.664014587990096*^9, 3.664014869880491*^9}, {3.6640156172920303`*^9, 
   3.6640156198320336`*^9}, {3.6640161270573425`*^9, 3.664016143617366*^9}, {
   3.665218724713929*^9, 3.6652187294081984`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubscriptBox["\<\"c\"\>", "1"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 1]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 1]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 1]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 1]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 1]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "2"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 2]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 2]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 2]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 2]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 2]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "3"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 3]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 3]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 3]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 3]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 3]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "4"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 4]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 4]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 4]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 4]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 4]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "5"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 5]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 5]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 5]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 5]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 5]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "6"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 6]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 6]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 6]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 6]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 6]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "7"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 7]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 7]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 7]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 7]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 7]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "8"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 8]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 8]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 8]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 8]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 8]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "9"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 9]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 9]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 9]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 9]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 9]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "10"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 10]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 10]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             10]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 10]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 10]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "11"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 11]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 11]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             11]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 11]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 11]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "12"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 12]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 12]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             12]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 12]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 12]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "13"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 13]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 13]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             13]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 13]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 13]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "14"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 14]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 14]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             14]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 14]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 14]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "15"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 15]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 15]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             15]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 15]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 15]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "16"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 16]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 16]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             16]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 16]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 16]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]},
    {
     SubscriptBox["\<\"c\"\>", "17"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 17]], {{1, 0}}, "\<\" increase \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 17]], {{0, 1}}, "\<\" decrease \"\>"], 
          SetterBox[Dynamic[
            
            Subscript[$CellContext`z, 
             17]], {{-1, -1}}, "\<\" unchanged \"\>"], 
          SetterBox[Dynamic[
            Subscript[$CellContext`z, 17]], {{0, 0}}, "\<\" free \"\>"]}
        },
        BaselinePosition->{1, 1},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True],
      SetterBar[
       Dynamic[
        Subscript[$CellContext`z, 17]], {{1, 0} -> " increase ", {0, 1} -> 
        " decrease ", {-1, -1} -> " unchanged ", {0, 0} -> " free "}]]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.5588669276313877`*^9, 3.558866947872416*^9}, {
   3.558867612538404*^9, 3.558867655584866*^9}, {3.558867730921175*^9, 
   3.5588677461960487`*^9}, {3.5588678879821587`*^9, 3.55886790811731*^9}, 
   3.5588707586080194`*^9, {3.558871869328549*^9, 3.558871889823721*^9}, 
   3.5588728648554897`*^9, 3.5590204147277675`*^9, 3.559021012798036*^9, 
   3.559021605914779*^9, 3.5590230799119425`*^9, 3.5590231111763973`*^9, 
   3.559026331410373*^9, {3.559026378151755*^9, 3.559026402535598*^9}, 
   3.559026499321168*^9, 3.5590290379486833`*^9, 3.559029842625574*^9, 
   3.5590320502028446`*^9, 3.5590320991411304`*^9, 3.559032152346846*^9, 
   3.5590322686298513`*^9, 3.559032316929536*^9, 3.5590323708562317`*^9, 
   3.5590324663005185`*^9, 3.559032574407181*^9, 3.5590326694233522`*^9, 
   3.5590342604529*^9, 3.5590342955429487`*^9, {3.5590344663003645`*^9, 
   3.5590345113309402`*^9}, 3.5590345837750835`*^9, 3.5590423112867613`*^9, 
   3.5590426568084326`*^9, 3.559042700576936*^9, 3.559042779823922*^9, 
   3.5592868246209135`*^9, 3.5592868905486293`*^9, {3.559287180694352*^9, 
   3.5592872311926413`*^9}, {3.559287308508377*^9, 3.5592873262622085`*^9}, 
   3.559297185526904*^9, 3.5592987331167326`*^9, 3.5592995035535884`*^9, 
   3.5593011634748106`*^9, 3.5595558944396176`*^9, 3.5596272999938283`*^9, 
   3.5596273549859734`*^9, 3.5596309365348263`*^9, 3.559631032243301*^9, 
   3.559631119431288*^9, 3.559900406302217*^9, 3.559901607969159*^9, 
   3.559901851037754*^9, {3.559902073198368*^9, 3.559902100389406*^9}, 
   3.559903430590189*^9, 3.5599034902636023`*^9, 3.5599036538169565`*^9, {
   3.559903727391165*^9, 3.5599037318394194`*^9}, 3.559904025367208*^9, 
   3.5666410005808372`*^9, 3.5734604207716274`*^9, {3.573460506956872*^9, 
   3.5734605264068995`*^9}, {3.579320035084361*^9, 3.57932004142437*^9}, 
   3.57970383536152*^9, {3.5797042304011154`*^9, 3.5797042585951552`*^9}, 
   3.579704297085209*^9, 3.5797099774403634`*^9, {3.579710054823472*^9, 
   3.579710072833497*^9}, 3.579710152063608*^9, {3.5797102155136967`*^9, 
   3.5797102198837028`*^9}, 3.579710622670906*^9, 3.5797818758637857`*^9, 
   3.5797850321780653`*^9, 3.5797866210723753`*^9, 3.58563675824975*^9, {
   3.585636806048234*^9, 3.5856368271082706`*^9}, 3.587897067378533*^9, 
   3.5878971010585804`*^9, 3.5878974060981393`*^9, 3.5878974689427433`*^9, 
   3.587897519661815*^9, {3.587897552293861*^9, 3.5878975838259068`*^9}, {
   3.5879699796616726`*^9, 3.587970013564032*^9}, 3.587970044691087*^9, 
   3.587971717813198*^9, 3.5879722390302505`*^9, 3.587973492984315*^9, {
   3.6635015534325686`*^9, 3.663501579728634*^9}, 3.6635016274307013`*^9, 
   3.6635016858409104`*^9, 3.663921463051175*^9, 3.663921503084465*^9, {
   3.663921542566723*^9, 3.6639215847621365`*^9}, 3.663921681629677*^9, 
   3.663922018353936*^9, 3.6639222121670218`*^9, {3.663922246627993*^9, 
   3.6639222657120843`*^9}, {3.6639225376456385`*^9, 3.663922571443571*^9}, {
   3.6639226416235857`*^9, 3.663922675078499*^9}, {3.6639231539838905`*^9, 
   3.663923188009837*^9}, {3.6639253606211033`*^9, 3.6639253852585125`*^9}, {
   3.663925450048218*^9, 3.6639254731135373`*^9}, {3.6639256077982407`*^9, 
   3.663925627960394*^9}, {3.6639303313224115`*^9, 3.6639303490534253`*^9}, 
   3.663930410065915*^9, 3.664014351289765*^9, {3.6640146019201155`*^9, 
   3.6640146453001766`*^9}, {3.6640146874902353`*^9, 3.664014696410248*^9}, {
   3.664014743600314*^9, 3.6640148709904923`*^9}, 3.6640149066856155`*^9, 
   3.664015012955764*^9, 3.664015050295816*^9, 3.6640152131570473`*^9, 
   3.6640155827819815`*^9, {3.6640156205620346`*^9, 3.6640156318020506`*^9}, 
   3.664015691022134*^9, {3.664016121077334*^9, 3.6640161440973663`*^9}, 
   3.664016542632677*^9, 3.6640165968427525`*^9, 3.6640167314939413`*^9, 
   3.66401939848678*^9, 3.664019439505127*^9, 3.6640196405576262`*^9, {
   3.6640196732474957`*^9, 3.664019698785957*^9}, {3.664019872769908*^9, 
   3.6640198871967335`*^9}, 3.664087534173188*^9, {3.664087568160768*^9, 
   3.6640876088108253`*^9}, {3.6640876528718867`*^9, 3.66408766936191*^9}, 
   3.6648615388148613`*^9, 3.6648615957869425`*^9, 3.664863253319263*^9, 
   3.6648632973293247`*^9, 3.6648634454515333`*^9, 3.6648634871715918`*^9, {
   3.66486899710528*^9, 3.664869024797324*^9}, 3.6648694721499753`*^9, 
   3.664869526482053*^9, 3.6648695750221205`*^9, {3.6648696100721693`*^9, 
   3.664869648906226*^9}, 3.6648719505713577`*^9, 3.664872315457145*^9, 
   3.6651213966632824`*^9, 3.6651223342172637`*^9, 3.665134923031907*^9, {
   3.6651349639789658`*^9, 3.6651349875789986`*^9}, 3.665218701439598*^9, {
   3.6652188332571373`*^9, 3.6652188726353903`*^9}, {3.665218933983899*^9, 
   3.6652189622965183`*^9}, 3.6652191289860525`*^9, 3.665738391930169*^9, {
   3.6657384442882423`*^9, 3.6657384505682516`*^9}, 3.665738605217972*^9, 
   3.665738643863026*^9, {3.6657387386261597`*^9, 3.66573874538717*^9}, 
   3.6657388137347813`*^9, 3.6700391791756725`*^9, {3.670039240709761*^9, 
   3.67003936334194*^9}, 3.6700485377742786`*^9, 3.670573633164179*^9, {
   3.670573670334305*^9, 3.6705737217882476`*^9}, 3.670576803396146*^9, 
   3.6715069173054047`*^9, 3.671506950090459*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Here the engineer can specify the the vector of \
importances for the characteristics. For simplicity the range of values are \
the natural numbers between 0 and 10. The initial valus are undefined, so \
they must be modified to initiate the algorithm. A good starting point would \
that of setting them all equal to 1, and then modify them further.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
  3.5590205880227747`*^9, 3.5590205933267837`*^9}, {3.5590206282084446`*^9, 
  3.5590206483958807`*^9}, {3.5590422710512047`*^9, 3.5590422837637224`*^9}, {
  3.664016786141037*^9, 3.664016812461074*^9}, {3.6651214284533267`*^9, 
  3.6651215271934648`*^9}, {3.6651216191235933`*^9, 3.6651216818137474`*^9}, {
  3.6651217575838537`*^9, 3.66512177631488*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", "=", "i"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\"\<\[Lambda]\>\"", "i"], ",", 
        RowBox[{"Slider", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", 
           SubscriptBox["\[Lambda]", "i"], "]"}], ",", 
          RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalLambda]", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SubscriptBox["\[Lambda]", "i"], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "char"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.664014363669782*^9, 3.664014368159788*^9}, {
  3.664014464879924*^9, 3.664014469809931*^9}, {3.664016677983866*^9, 
  3.664016681503871*^9}, {3.6651217072637835`*^9, 3.665121718743799*^9}, {
  3.6651349167788982`*^9, 3.6651349197889028`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "1"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 1]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 1]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 1]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "2"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 2]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 2]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 2]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "3"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 3]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 3]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 3]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "4"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 4]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 4]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 4]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "5"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 5]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 5]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 5]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "6"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 6]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 6]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 6]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "7"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 7]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 7]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 7]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "8"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 8]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 8]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 8]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "9"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 9]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 9]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 9]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "10"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 10]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 10]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 10]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "11"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 11]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 11]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 11]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "12"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 12]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 12]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 12]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "13"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 13]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 13]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 13]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "14"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 14]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 14]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 14]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "15"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 15]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 15]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 15]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "16"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 16]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 16]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 16]], {0, 10, 1}]]},
    {
     SubscriptBox["\<\"\[Lambda]\"\>", "17"], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          SliderBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 17]], {0, 10, 1},
           Appearance->Automatic,
           DefaultBaseStyle->"LabeledSlider"], 
          InputFieldBox[Dynamic[
            Subscript[$CellContext`\[Lambda], 17]],
           Appearance->"Frameless",
           ContinuousAction->True,
           DefaultBaseStyle->"LabeledSlider",
           FieldSize->{{5, 10}, {1, 2}},
           ImageMargins->0]}
        },
        AutoDelete->False,
        BaselinePosition->{{1, 1}, Axis},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Deployed->True,
       StripOnInput->False,
       FontFamily:>CurrentValue["ControlsFontFamily"]],
      LabeledSlider[
       Dynamic[
        Subscript[$CellContext`\[Lambda], 17]], {0, 10, 1}]]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.664014339909749*^9, 3.6640143688697896`*^9}, 
   3.664014466299926*^9, {3.6640145518600454`*^9, 3.664014559360056*^9}, 
   3.6640149067356153`*^9, 3.664015012995764*^9, 3.6640150503358164`*^9, 
   3.6640152131870475`*^9, 3.6640155828519816`*^9, 3.6640156318420506`*^9, 
   3.6640156910541344`*^9, 3.664016121107334*^9, 3.664016542702677*^9, 
   3.6640165968827524`*^9, 3.6640166824538727`*^9, {3.664016722753929*^9, 
   3.6640167315439415`*^9}, 3.6640193987647963`*^9, 3.6640194395471287`*^9, 
   3.6640196406996346`*^9, {3.664019673281498*^9, 3.6640196988269587`*^9}, {
   3.6640198728099103`*^9, 3.664019887231735*^9}, 3.664087534213188*^9, {
   3.6640875682007685`*^9, 3.6640876088508253`*^9}, {3.6640876529118867`*^9, 
   3.66408766939191*^9}, 3.6648615388648615`*^9, 3.664861595846943*^9, 
   3.6648632533592634`*^9, 3.6648632973693247`*^9, 3.6648634454915333`*^9, 
   3.664863487221592*^9, {3.6648689971532803`*^9, 3.664869024837324*^9}, 
   3.6648694721999755`*^9, 3.664869526632053*^9, 3.6648695750721207`*^9, {
   3.664869610154171*^9, 3.664869648946226*^9}, 3.6648719506013575`*^9, 
   3.6648723154971457`*^9, {3.665121696463768*^9, 3.6651217472438393`*^9}, 
   3.665121778984884*^9, 3.665121885075032*^9, 3.665122334257264*^9, 
   3.665134923128908*^9, {3.6651349640489655`*^9, 3.665134987638999*^9}, 
   3.665218743022977*^9, {3.6652188333081408`*^9, 3.665218872694393*^9}, {
   3.665218934055903*^9, 3.665218962380523*^9}, 3.665219129054056*^9, 
   3.665738404172186*^9, {3.665738447238247*^9, 3.665738450651252*^9}, 
   3.665738605287972*^9, 3.6657386439330263`*^9, {3.66573873868616*^9, 
   3.6657387454571695`*^9}, 3.6657388137947817`*^9, {3.670039216527726*^9, 
   3.67003936338194*^9}, 3.67004853785428*^9, 3.6705736332291822`*^9, {
   3.670573670403309*^9, 3.670573721861252*^9}, 3.670576803463647*^9, 
   3.6715069173854055`*^9, 3.6715069501604595`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.664014339909749*^9, 3.6640143688697896`*^9}, 
   3.664014466299926*^9, {3.6640145518600454`*^9, 3.664014559360056*^9}, 
   3.6640149067356153`*^9, 3.664015012995764*^9, 3.6640150503358164`*^9, 
   3.6640152131870475`*^9, 3.6640155828519816`*^9, 3.6640156318420506`*^9, 
   3.6640156910541344`*^9, 3.664016121107334*^9, 3.664016542702677*^9, 
   3.6640165968827524`*^9, 3.6640166824538727`*^9, {3.664016722753929*^9, 
   3.6640167315439415`*^9}, 3.6640193987647963`*^9, 3.6640194395471287`*^9, 
   3.6640196406996346`*^9, {3.664019673281498*^9, 3.6640196988269587`*^9}, {
   3.6640198728099103`*^9, 3.664019887231735*^9}, 3.664087534213188*^9, {
   3.6640875682007685`*^9, 3.6640876088508253`*^9}, {3.6640876529118867`*^9, 
   3.66408766939191*^9}, 3.6648615388648615`*^9, 3.664861595846943*^9, 
   3.6648632533592634`*^9, 3.6648632973693247`*^9, 3.6648634454915333`*^9, 
   3.664863487221592*^9, {3.6648689971532803`*^9, 3.664869024837324*^9}, 
   3.6648694721999755`*^9, 3.664869526632053*^9, 3.6648695750721207`*^9, {
   3.664869610154171*^9, 3.664869648946226*^9}, 3.6648719506013575`*^9, 
   3.6648723154971457`*^9, {3.665121696463768*^9, 3.6651217472438393`*^9}, 
   3.665121778984884*^9, 3.665121885075032*^9, 3.665122334257264*^9, 
   3.665134923128908*^9, {3.6651349640489655`*^9, 3.665134987638999*^9}, 
   3.665218743022977*^9, {3.6652188333081408`*^9, 3.665218872694393*^9}, {
   3.665218934055903*^9, 3.665218962380523*^9}, 3.665219129054056*^9, 
   3.665738404172186*^9, {3.665738447238247*^9, 3.665738450651252*^9}, 
   3.665738605287972*^9, 3.6657386439330263`*^9, {3.66573873868616*^9, 
   3.6657387454571695`*^9}, 3.6657388137947817`*^9, {3.670039216527726*^9, 
   3.67003936338194*^9}, 3.67004853785428*^9, 3.6705736332291822`*^9, {
   3.670573670403309*^9, 3.670573721861252*^9}, 3.670576803463647*^9, 
   3.6715069173854055`*^9, 3.6715069501704593`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["By using the partition of characteristics and their \
weights we can write down the objective function.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
  3.5590205880227747`*^9, 3.5590206161964235`*^9}, {3.5590422321606493`*^9, 
  3.5590422600161886`*^9}, {3.6651218231949453`*^9, 3.6651218664650064`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J", "=", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"j", "=", "1"}], "char"], 
   RowBox[{
    RowBox[{"\[CapitalLambda]", "[", 
     RowBox[{"[", "j", "]"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Theta]", "+"], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "*", 
       SubsuperscriptBox["d", "j", "+"]}], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Theta]", "-"], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "*", 
       SubsuperscriptBox["d", "j", "-"]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5588600847880187`*^9, 3.5588600850510335`*^9}, {
   3.5588601203100505`*^9, 3.5588601938232555`*^9}, {3.5588616671423855`*^9, 
   3.558861755723452*^9}, {3.558861818174024*^9, 3.5588618312867737`*^9}, {
   3.5588618702170005`*^9, 3.5588618760743356`*^9}, {3.5588619934000463`*^9, 
   3.5588619963582153`*^9}, {3.5588719757906384`*^9, 
   3.5588719833920727`*^9}, {3.559042378697363*^9, 3.559042385937373*^9}, 
   3.664014503499978*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["d", "4"], ")"}], "-"]}], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "5"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "6"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "7"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "8"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "9"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "10"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "11"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "12"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "13"], ")"}], "-"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "14"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "15"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "16"], ")"}], "-"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "1"], ")"}], "+"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "2"], ")"}], "+"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "3"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "4"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "5"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "6"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "7"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "8"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "12"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "13"], ")"}], "+"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    SubscriptBox["d", "14"], ")"}], "+"]}]], "Output",
 CellChangeTimes->{
  3.558860194940319*^9, {3.558861673240734*^9, 3.5588617152881393`*^9}, 
   3.5588617564044905`*^9, {3.558861864416669*^9, 3.5588618780584493`*^9}, 
   3.558861940191003*^9, {3.558861976210063*^9, 3.5588619970692563`*^9}, {
   3.5588620502812996`*^9, 3.55886205972884*^9}, 3.55886241499516*^9, 
   3.5588630854015055`*^9, {3.5588648665813828`*^9, 3.5588648872405643`*^9}, 
   3.558865670994474*^9, 3.5588657108117514`*^9, 3.5588658235341988`*^9, {
   3.558865888822933*^9, 3.558865897019368*^9}, 3.5588659287004128`*^9, 
   3.5588661390500174`*^9, 3.5588662840629864`*^9, 3.558866370071906*^9, 
   3.558866528563472*^9, 3.5588668435272694`*^9, 3.5588668831703253`*^9, 
   3.55886695065242*^9, 3.5588676271352386`*^9, 3.558867657420971*^9, 
   3.558867748060155*^9, 3.558867909919413*^9, 3.558870760029101*^9, {
   3.558871872086707*^9, 3.55887189084678*^9}, 3.5588719842741237`*^9, 
   3.5588728659095497`*^9, 3.559020574724434*^9, 3.559021015359183*^9, 
   3.5590216080363827`*^9, 3.5590231112075977`*^9, 3.559026331441573*^9, {
   3.559026378182955*^9, 3.5590264025667977`*^9}, 3.5590264993523684`*^9, 
   3.559029040679688*^9, 3.559029842656774*^9, 3.5590320502184443`*^9, 
   3.5590320991723304`*^9, 3.559032152378046*^9, 3.5590322686610513`*^9, 
   3.559032316945136*^9, 3.5590323709030313`*^9, 3.5590324663317184`*^9, 
   3.5590325744321823`*^9, 3.5590326694545527`*^9, 3.559034299232954*^9, {
   3.5590344663323665`*^9, 3.559034511396944*^9}, 3.5590345838320875`*^9, 
   3.559042311366761*^9, 3.5590423937973843`*^9, 3.5590425146315536`*^9, 
   3.5590426602956314`*^9, 3.5590427006309385`*^9, 3.5590427798739223`*^9, 
   3.559286828895321*^9, 3.5592868906110296`*^9, {3.5592871807567525`*^9, 
   3.559287231255041*^9}, {3.559287308570777*^9, 3.5592873263246083`*^9}, 
   3.5592971888185096`*^9, 3.559298733216733*^9, 3.559299503662789*^9, 
   3.559301168342019*^9, 3.559555899015879*^9, 3.559627390367997*^9, 
   3.559630936609831*^9, {3.559631037102579*^9, 3.5596310477651887`*^9}, 
   3.559631124555581*^9, 3.559900409192221*^9, 3.559901611335165*^9, 
   3.559901855707761*^9, 3.559902073268368*^9, 3.559902105139413*^9, 
   3.559903433985383*^9, {3.5599034713225183`*^9, 3.5599034934167824`*^9}, 
   3.559903658716237*^9, 3.5599037319044228`*^9, 3.5599040288714085`*^9, 
   3.5666410006408377`*^9, 3.5734604256216345`*^9, {3.5734605070168724`*^9, 
   3.5734605264568996`*^9}, 3.5793200541243873`*^9, 3.57970383540152*^9, 
   3.579704258615155*^9, 3.5797042971052094`*^9, 3.5797099774703636`*^9, {
   3.5797100548534718`*^9, 3.579710072883497*^9}, 3.579710152093608*^9, 
   3.579710219913703*^9, 3.579710622710906*^9, 3.579781880913793*^9, 
   3.5797850322380657`*^9, 3.5797866210879755`*^9, 3.58563675828095*^9, {
   3.5856368060950336`*^9, 3.585636827139471*^9}, {3.5878970719885397`*^9, 
   3.5878971010985804`*^9}, 3.587897406148139*^9, 3.5878974689827433`*^9, 
   3.587897519701815*^9, {3.587897555073865*^9, 3.5878975838659067`*^9}, 
   3.5879699798800726`*^9, 3.587970013595232*^9, 3.587970044737887*^9, 
   3.5879717178556986`*^9, 3.58797223907705*^9, 3.587973493034315*^9, {
   3.663501553452569*^9, 3.6635015797386336`*^9}, 3.6635016274507017`*^9, 
   3.6635016858609104`*^9, 3.6639214633151903`*^9, {3.663921503338479*^9, 
   3.6639215848001385`*^9}, 3.6639216816676793`*^9, 3.663922018379938*^9, 
   3.6639222121920233`*^9, {3.663922246645994*^9, 3.663922265731086*^9}, 
   3.66392253767764*^9, 3.663922584337309*^9, 3.663922641896601*^9, 
   3.663922675114501*^9, {3.6639231540128927`*^9, 3.6639231880268383`*^9}, {
   3.6639253606471047`*^9, 3.6639253852745132`*^9}, 3.6639254731335382`*^9, {
   3.663925607816242*^9, 3.663925627979395*^9}, {3.663930331340412*^9, 
   3.663930349075426*^9}, 3.663930410086916*^9, 3.6640143513397646`*^9, 
   3.6640145047599792`*^9, 3.6640149067656155`*^9, 3.664015013015764*^9, 
   3.664015050365816*^9, {3.664015177325994*^9, 3.6640152132170477`*^9}, 
   3.664015583071982*^9, 3.6640156318720503`*^9, 3.6640156910741343`*^9, 
   3.664016121137334*^9, 3.6640165427426767`*^9, 3.664016596902753*^9, 
   3.664016731573941*^9, 3.6640193988007984`*^9, 3.6640194395711308`*^9, 
   3.6640196407336364`*^9, {3.664019673303499*^9, 3.6640196988489604`*^9}, {
   3.6640198728309116`*^9, 3.6640198872557364`*^9}, 3.6640875342331877`*^9, {
   3.664087568220768*^9, 3.6640876088708253`*^9}, {3.6640876529318867`*^9, 
   3.6640876694219103`*^9}, 3.664861538884862*^9, 3.6648615958769426`*^9, 
   3.664863253389263*^9, 3.664863297399325*^9, 3.6648634455215335`*^9, 
   3.6648634872415915`*^9, {3.6648689971832805`*^9, 3.6648690248573246`*^9}, 
   3.6648694722299757`*^9, 3.664869526662053*^9, 3.664869575102121*^9, {
   3.6648696101841707`*^9, 3.6648696489662266`*^9}, 3.6648719506313577`*^9, 
   3.6648723155271454`*^9, 3.66512173331382*^9, {3.6651218689250097`*^9, 
   3.6651218877250357`*^9}, 3.665122334277264*^9, 3.665134923168908*^9, {
   3.665134964078966*^9, 3.6651349876689987`*^9}, 3.665218746648184*^9, {
   3.665218833330142*^9, 3.6652188727183948`*^9}, {3.6652189340799046`*^9, 
   3.6652189624085245`*^9}, 3.6652191290760574`*^9, 3.6657384172642045`*^9, 
   3.665738450668253*^9, 3.665738605317972*^9, 3.665738643963026*^9, {
   3.6657387387161603`*^9, 3.6657387454871697`*^9}, 3.6657388138147817`*^9, {
   3.670039221667733*^9, 3.6700393634119406`*^9}, 3.67004853787928*^9, 
   3.670573633259184*^9, {3.67057367042331*^9, 3.6705737218862534`*^9}, 
   3.6705768034861474`*^9, 3.6715069174154053`*^9, 3.6715069501904593`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["This defines the constraints. What is visualized is \
the left hand side of the constraints, the right hand side is the vector 0.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
  3.5590205880227747`*^9, 3.5590206161964235`*^9}, {3.559021090005452*^9, 
  3.5590212309665146`*^9}, {3.5590213377457747`*^9, 3.559021377588831*^9}, {
  3.6651219189750795`*^9, 3.6651219484851213`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "R", "]"}], ".", 
    OverscriptBox["x", "\[RightVector]"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Theta]", "+"], "[", 
        RowBox[{"[", "j", "]"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[Theta]", "-"], "[", 
        RowBox[{"[", "j", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"[", "j", "]"}], "]"}], "=", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "char"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"De", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Theta]", "-"], "*", 
     SubscriptBox["d", "-"]}], "-", 
    RowBox[{
     SuperscriptBox["\[Theta]", "+"], "*", 
     SubscriptBox["d", "+"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"A", "+", "De"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5588621235844927`*^9, 3.5588621254766006`*^9}, {
  3.558862160707616*^9, 3.558862180104725*^9}, {3.5588623248250027`*^9, 
  3.5588623958840675`*^9}, {3.558862428859953*^9, 3.5588624657800646`*^9}, {
  3.5588625286086583`*^9, 3.558862538189206*^9}, {3.558865663076021*^9, 
  3.5588656656831703`*^9}, {3.558866433227518*^9, 3.558866516993455*^9}, {
  3.5588665566759114`*^9, 3.558866602887777*^9}, {3.5590210668611283`*^9, 
  3.5590210691412587`*^9}, {3.6640163328101606`*^9, 3.6640163432201753`*^9}, {
  3.665121930645096*^9, 3.665121975205158*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "10"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "13"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "15"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "18"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "1"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "10"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "18"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "2"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "10"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "15"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "17"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "18"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "3"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "2"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "10"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "15"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "4"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "4"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "9"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "10"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "13"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "14"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "15"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "16"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "5"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "5"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "10"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "6"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "6"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "10"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "11"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "15"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "7"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "7"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "10"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "15"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "8"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "8"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "15"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "23"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "24"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "9"], ")"}], "-"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "15"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "23"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "24"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "10"], ")"}], "-"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "10"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "11"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "13"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "16"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "23"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "24"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "11"], ")"}], "-"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "7"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "12"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "12"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "12"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "6"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "12"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "15"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "20"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "21"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "22"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "23"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "13"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "13"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "14"], ")"}], "-"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "14"], ")"}], "+"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "2"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "3"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "4"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "5"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "6"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "7"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "9"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "10"]}], "+", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "11"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "13"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "14"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "17"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "18"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "19"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "20"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "21"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "22"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "15"], ")"}], "-"]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["x", "1"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "4"]}], "-", 
        RowBox[{"2.`", " ", 
         SubscriptBox["x", "5"]}], "-", 
        RowBox[{"3.`", " ", 
         SubscriptBox["x", "6"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox["d", "16"], ")"}], "-"]}]},
      {"0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.558862600071746*^9, 3.5588630863495593`*^9, 3.5588648883516283`*^9, 
   3.5588657127708635`*^9, 3.5588658268973913`*^9, 3.5588658978893695`*^9, 
   3.5588659295204144`*^9, 3.5588661398300185`*^9, 3.55886629076437*^9, 
   3.5588663708989534`*^9, {3.5588665181526566`*^9, 3.558866529443473*^9}, {
   3.558866561185918*^9, 3.5588666036077776`*^9}, 3.5588668453172717`*^9, 
   3.5588668845803275`*^9, 3.5588669538124247`*^9, 3.5588676283693094`*^9, 
   3.5588676589390583`*^9, 3.55886774919522*^9, 3.5588679111174817`*^9, 
   3.558870761099162*^9, {3.558871876452956*^9, 3.558871891688828*^9}, 
   3.558871985490193*^9, 3.558872866819602*^9, 3.5590210168772697`*^9, 
   3.559021069786296*^9, 3.5590216103763866`*^9, 3.5590231112387977`*^9, 
   3.5590263314883733`*^9, {3.559026378214155*^9, 3.5590264025979977`*^9}, 
   3.559026499399168*^9, 3.5590290427076917`*^9, 3.559029842687974*^9, 
   3.5590320502652445`*^9, 3.5590320992035303`*^9, 3.5590321524248457`*^9, 
   3.559032268692251*^9, 3.559032316991936*^9, 3.5590323709342318`*^9, 
   3.559032466394119*^9, 3.559032574494582*^9, 3.5590326695013523`*^9, 
   3.559034301742957*^9, {3.5590344663983707`*^9, 3.559034511432946*^9}, 
   3.5590345838700895`*^9, 3.559042311426761*^9, 3.559042524011566*^9, 
   3.5590426626587667`*^9, 3.5590427006709414`*^9, 3.5590427799139223`*^9, 
   3.5592868372101355`*^9, 3.5592868906422296`*^9, {3.5592871807879524`*^9, 
   3.5592872312862415`*^9}, {3.5592873086019773`*^9, 3.5592873263558083`*^9}, 
   3.559297190862113*^9, 3.559298733266733*^9, 3.559299503693989*^9, 
   3.559301169870822*^9, 3.559555901117999*^9, 3.559627399737533*^9, 
   3.5596309366758347`*^9, 3.5596310499073114`*^9, 3.5596311266977034`*^9, 
   3.5599004109822235`*^9, 3.559901612755167*^9, 3.559901857267763*^9, 
   3.559902073308368*^9, 3.5599021070894156`*^9, 3.559903435555473*^9, {
   3.5599034727235985`*^9, 3.559903494892867*^9}, 3.5599036605833435`*^9, 
   3.5599037319424253`*^9, 3.559904030233486*^9, 3.5666410006708374`*^9, 
   3.5734604285616384`*^9, {3.5734605070368724`*^9, 3.5734605264868994`*^9}, 
   3.5797038354415197`*^9, 3.579704258645155*^9, 3.579704297125209*^9, 
   3.579709977520364*^9, {3.579710054873472*^9, 3.579710072913497*^9}, 
   3.579710152113608*^9, 3.5797102199437027`*^9, 3.579710622760906*^9, 
   3.579781883563797*^9, 3.579785032288066*^9, 3.579786621119176*^9, 
   3.58563675831215*^9, {3.585636806126234*^9, 3.5856368271706715`*^9}, {
   3.5878970749985437`*^9, 3.5878971011385803`*^9}, 3.5878974062081394`*^9, 
   3.5878974691527433`*^9, 3.5878975198218155`*^9, {3.587897555113865*^9, 
   3.587897583885907*^9}, 3.587969980145273*^9, 3.587970013626432*^9, 
   3.5879700447534866`*^9, 3.5879717178781986`*^9, 3.5879722391082506`*^9, 
   3.5879734930543146`*^9, {3.6635015534725685`*^9, 3.6635015797586336`*^9}, 
   3.6635016274807014`*^9, 3.6635016858809104`*^9, 3.663921463746215*^9, 
   3.6639215037905054`*^9, {3.663921543267763*^9, 3.663921584839141*^9}, 
   3.6639216817046814`*^9, 3.6639220184449415`*^9, 3.6639222122460265`*^9, {
   3.6639222466899967`*^9, 3.663922265776088*^9}, 3.6639225378896523`*^9, 
   3.6639225884295425`*^9, 3.663922642391629*^9, 3.663922675185505*^9, {
   3.6639231544379168`*^9, 3.6639231880418386`*^9}, {3.663925360702108*^9, 
   3.6639253852915144`*^9}, 3.663925473173541*^9, {3.6639256078632445`*^9, 
   3.6639256280313983`*^9}, {3.663930331394415*^9, 3.6639303491314297`*^9}, 
   3.663930410138919*^9, 3.6640143513697653`*^9, 3.6640145114099894`*^9, 
   3.664014906795615*^9, 3.6640150130757637`*^9, 3.664015050405816*^9, 
   3.6640152132470474`*^9, 3.664015583471983*^9, 3.6640156319220505`*^9, 
   3.6640156911141343`*^9, 3.664016121187334*^9, {3.664016337370167*^9, 
   3.664016343970176*^9}, 3.6640165427826767`*^9, 3.664016596952753*^9, 
   3.664016731603941*^9, 3.6640193988818035`*^9, 3.6640194396271334`*^9, 
   3.66401964080164*^9, {3.6640196733395014`*^9, 3.664019698884962*^9}, {
   3.664019872895915*^9, 3.6640198873067393`*^9}, 3.664087534283188*^9, {
   3.664087568270768*^9, 3.664087608920825*^9}, {3.664087652981887*^9, 
   3.66408766947191*^9}, 3.6648615389348617`*^9, 3.664861595926943*^9, 
   3.664863253419263*^9, 3.664863297439325*^9, 3.6648634455615335`*^9, 
   3.664863487261592*^9, {3.6648689972232804`*^9, 3.6648690249073243`*^9}, 
   3.664869472279976*^9, 3.664869526732053*^9, 3.6648695751521206`*^9, {
   3.664869610244171*^9, 3.664869649016227*^9}, 3.6648719506813574`*^9, 
   3.6648723155771456`*^9, 3.6651221390099463`*^9, 3.6651223343472643`*^9, 
   3.6651349232289085`*^9, {3.665134964138966*^9, 3.6651349877089987`*^9}, 
   3.665218750713416*^9, {3.665218833387145*^9, 3.6652188727753983`*^9}, {
   3.665218934161909*^9, 3.6652189624865294`*^9}, 3.6652191291260605`*^9, 
   3.665738419984208*^9, 3.665738450708253*^9, 3.665738605347972*^9, 
   3.6657386439930267`*^9, {3.6657387387461605`*^9, 3.66573874552717*^9}, 
   3.6657388138747816`*^9, {3.670039224527737*^9, 3.6700393634419403`*^9}, 
   3.6700485379167805`*^9, 3.6705736333211875`*^9, {3.6705736704643126`*^9, 
   3.670573721925256*^9}, 3.670576803518648*^9, 3.671506917455405*^9, 
   3.6715069502404594`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Here we show the maximum number of characteristics \
that we want to modify.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
   3.5590205880227747`*^9, 3.5590206161964235`*^9}, {3.559021090005452*^9, 
   3.5590212309665146`*^9}, {3.5590213377457747`*^9, 3.559021377588831*^9}, {
   3.5590227762680087`*^9, 3.559022842771926*^9}, {3.559022934751687*^9, 
   3.559022977917963*^9}, 3.5590290722873435`*^9, {3.6651220024251966`*^9, 
   3.665122046659817*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", "5"}]], "Input",
 CellChangeTimes->{{3.559631017126436*^9, 3.55963101789148*^9}, {
   3.559901597479144*^9, 3.559901635595251*^9}, {3.559901867967778*^9, 
   3.559901896958819*^9}, 3.5599020704583645`*^9, {3.5599021228304377`*^9, 
   3.559902145293496*^9}, {3.5599034768988376`*^9, 3.559903477777888*^9}, {
   3.559903749252415*^9, 3.5599038351353273`*^9}, 3.5599039223113136`*^9, {
   3.5599040335566764`*^9, 3.559904033739687*^9}, {3.5734604790568333`*^9, 
   3.5734605041268682`*^9}, 3.579703849351539*^9, 3.5797100694434924`*^9, {
   3.5879734210322123`*^9, 3.587973421732213*^9}, {3.5879734859143047`*^9, 
   3.58797348956431*^9}, {3.6635016530437946`*^9, 3.663501653933796*^9}, 
   3.6639222045855885`*^9, {3.6639222443678637`*^9, 3.663922263608964*^9}, 
   3.6640198845085793`*^9, 3.664087616600836*^9, 3.664087667271907*^9, {
   3.665218959332349*^9, 3.665218959372351*^9}, 3.665219118163433*^9, 
   3.665738424655215*^9, {3.665738743307167*^9, 3.6657387433671665`*^9}, {
   3.670039230007745*^9, 3.6700392623197913`*^9}, {3.6700393005638475`*^9, 
   3.670039318765874*^9}, 3.6705736858491917`*^9, 3.6705737198411365`*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.5596310570987225`*^9, 3.5596311289778337`*^9, 3.5599004144332285`*^9, {
   3.559901598559146*^9, 3.5599016364823017`*^9}, {3.559901859907767*^9, 
   3.5599018976288195`*^9}, 3.559902073368368*^9, {3.5599021093494186`*^9, 
   3.559902145899531*^9}, {3.559903479192969*^9, 3.5599034970619907`*^9}, 
   3.5599036627444673`*^9, {3.5599037319834275`*^9, 3.559903836007377*^9}, 
   3.559903923032355*^9, 3.559904034055705*^9, 3.566641000690838*^9, 
   3.5734604329416447`*^9, {3.5734604887168465`*^9, 3.5734605265168996`*^9}, {
   3.5797038354815197`*^9, 3.5797038517715425`*^9}, 3.5797042586651554`*^9, 
   3.5797042971452093`*^9, 3.5797099775503635`*^9, {3.579710054903472*^9, 
   3.579710072953497*^9}, 3.579710152163608*^9, 3.5797102199737034`*^9, 
   3.5797106227909064`*^9, 3.579781887023802*^9, 3.579785032348066*^9, 
   3.579786621181576*^9, 3.5856367583589506`*^9, {3.5856368061574345`*^9, 
   3.585636827217471*^9}, {3.587897077758548*^9, 3.5878971011885805`*^9}, 
   3.5878974062481394`*^9, 3.5878974692027435`*^9, 3.5878975198718157`*^9, {
   3.587897555143865*^9, 3.5878975839059067`*^9}, 3.587969980207673*^9, 
   3.587970013657632*^9, 3.587970044769087*^9, 3.587971717903199*^9, 
   3.587972239123851*^9, 3.5879734243322167`*^9, 3.587973493074315*^9, {
   3.6635015534825687`*^9, 3.6635015797586336`*^9}, 3.6635016274907017`*^9, 
   3.66350168589091*^9, 3.663921463802218*^9, 3.663921503854509*^9, {
   3.6639215433417673`*^9, 3.6639215848521414`*^9}, 3.6639216817376833`*^9, 
   3.6639220184759436`*^9, 3.6639222122590275`*^9, {3.6639222467019973`*^9, 
   3.6639222657890887`*^9}, 3.663922537932655*^9, 3.663922591913742*^9, 
   3.663922642495635*^9, 3.663922675207506*^9, {3.6639231544729185`*^9, 
   3.6639231880548396`*^9}, {3.6639253607161083`*^9, 3.663925385299515*^9}, 
   3.6639254732005424`*^9, {3.663925607888246*^9, 3.6639256280614*^9}, {
   3.6639303314384174`*^9, 3.6639303491494308`*^9}, 3.6639304101499195`*^9, 
   3.6640143514097652`*^9, 3.6640145157599955`*^9, 3.664014906815615*^9, 
   3.664015013105764*^9, 3.6640150504358163`*^9, 3.6640152132770476`*^9, 
   3.6640155834819827`*^9, 3.6640156319420505`*^9, 3.6640156911441345`*^9, 
   3.664016121227334*^9, 3.664016542812677*^9, 3.664016596992753*^9, 
   3.664016731633941*^9, 3.664019398914805*^9, 3.6640194396481347`*^9, 
   3.6640196408206415`*^9, {3.664019673351502*^9, 3.664019698894963*^9}, {
   3.6640198731269283`*^9, 3.6640198873537416`*^9}, 3.6640875343031883`*^9, {
   3.664087568310768*^9, 3.664087608960825*^9}, {3.664087653021887*^9, 
   3.66408766949191*^9}, 3.6648615389548616`*^9, 3.6648615959569426`*^9, 
   3.664863253459263*^9, 3.664863297479325*^9, 3.664863445571533*^9, 
   3.664863487301592*^9, {3.6648689972732806`*^9, 3.6648690249473248`*^9}, 
   3.6648694723099756`*^9, 3.664869526772053*^9, 3.664869575182121*^9, {
   3.664869610274171*^9, 3.6648696490462265`*^9}, 3.664871950701358*^9, 
   3.6648723156071453`*^9, 3.6651221428799515`*^9, 3.665122334357264*^9, 
   3.6651349232689085`*^9, {3.6651349641689663`*^9, 3.665134987738999*^9}, 
   3.6652187564927473`*^9, {3.6652188334221473`*^9, 3.6652188728054*^9}, {
   3.6652189341979113`*^9, 3.6652189625295315`*^9}, {3.6652191258158712`*^9, 
   3.665219129156062*^9}, {3.665738425525216*^9, 3.6657384507382526`*^9}, 
   3.6657386053779716`*^9, 3.6657386440140266`*^9, {3.6657387387661605`*^9, 
   3.66573874556717*^9}, 3.665738813884782*^9, {3.6700392316677475`*^9, 
   3.6700393634819403`*^9}, 3.6700485379517813`*^9, 3.670573633331188*^9, {
   3.670573670477313*^9, 3.670573721935256*^9}, 3.670576803528648*^9, 
   3.671506917495405*^9, 3.671506950250459*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["This is the real optimization problem which has to be \
solved. The entire command returns:\n- The value of the objective function\n- \
The optimal solution\n- A print out of the time taken from the algorithm.",
 FontWeight->"Plain"]], "Subsection",
 CellChangeTimes->{{3.559019426026662*^9, 3.559019575551959*^9}, {
   3.5590205880227747`*^9, 3.5590206161964235`*^9}, {3.559021090005452*^9, 
   3.5590212309665146`*^9}, {3.5590213377457747`*^9, 3.559021377588831*^9}, {
   3.5590227762680087`*^9, 3.559022842771926*^9}, {3.559022934751687*^9, 
   3.559022977917963*^9}, 3.5590290722873435`*^9, {3.6651220655398436`*^9, 
   3.6651221117199078`*^9}, {3.6651221867100134`*^9, 3.6651222855601516`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "=", 
    RowBox[{"Date", "[", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sol", "=", 
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"J", ",", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["d", "j", "-"], "\[GreaterEqual]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "char"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["d", "j", "+"], "\[GreaterEqual]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "char"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["x", "i"], "\[GreaterEqual]", 
           RowBox[{"-", "1"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "fac"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["x", "i"], "\[LessEqual]", "1"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "fac"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"A", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "+", 
            RowBox[{"De", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "==", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "char"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["x", "i", "-"], "\[GreaterEqual]", "0"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["x", "i", "+"], "\[GreaterEqual]", "0"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["x", "i", "-"], "\[LessEqual]", "1"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["x", "i", "+"], "\[LessEqual]", "1"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SubscriptBox["x", "i"], "+", 
             SubsuperscriptBox["x", "i", "-"], "-", 
             SubsuperscriptBox["x", "i", "+"]}], "==", "0"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SubsuperscriptBox["x", "i", "-"], "+", 
             SubsuperscriptBox["x", "i", "+"]}], "\[LessEqual]", "1"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "fac"}], "}"}]}], "]"}],
         FontColor->GrayLevel[0]], 
        StyleBox[",",
         FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"i", "=", "1"}], "fac"], 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["x", "i", "+"], "+", 
             SubsuperscriptBox["x", "i", "-"]}], ")"}]}], "\[LessEqual]", 
          "b"}],
         FontColor->GrayLevel[0]]}], 
       StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          SubsuperscriptBox["d", "j", "-"], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "char"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubsuperscriptBox["d", "j", "+"], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "char"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["x", "i"], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "fac"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubsuperscriptBox["x", "i", "-"], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "fac"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubsuperscriptBox["x", "i", "+"], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "fac"}], "}"}]}], "]"}]}], "]"}], ",", 
      "Integers"}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Sol", "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sol", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"char", "*", "2"}], ")"}], "+", "i"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "fac"}], "}"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Date", "[", "]"}], "-", "a"}]}], "Input",
 CellChangeTimes->{{3.5588626301374655`*^9, 3.5588626462533875`*^9}, {
   3.5588626890938377`*^9, 3.558862695040178*^9}, {3.558862765840227*^9, 
   3.558862811470837*^9}, {3.558862846954867*^9, 3.558862966305693*^9}, {
   3.5588631499061947`*^9, 3.558863178789847*^9}, {3.5588632137308455`*^9, 
   3.558863237562208*^9}, {3.5588646938555036`*^9, 3.55886479904352*^9}, {
   3.558864894839999*^9, 3.5588649094798365`*^9}, {3.5588649551424484`*^9, 
   3.5588650134337826`*^9}, {3.5588650443125486`*^9, 
   3.5588650444705577`*^9}, {3.5588653810852346`*^9, 3.55886538403364*^9}, {
   3.5588655250281253`*^9, 3.558865574470953*^9}, {3.558865755160288*^9, 
   3.5588657715062227`*^9}, {3.5588659080503836`*^9, 3.558865909590386*^9}, {
   3.5588661555010405`*^9, 3.5588661760020695`*^9}, {3.558867644589237*^9, 
   3.558867645936314*^9}, {3.558867680531293*^9, 3.558867682207389*^9}, {
   3.558869531564166*^9, 3.5588695414727325`*^9}, {3.558869622072343*^9, 
   3.558869626328586*^9}, {3.558871896818121*^9, 3.5588719114409575`*^9}, {
   3.5588719560565095`*^9, 3.5588719607217765`*^9}, {3.5588725804682236`*^9, 
   3.5588726231326637`*^9}, {3.558872686094265*^9, 3.5588727807236776`*^9}, {
   3.558872812609502*^9, 3.5588728459814105`*^9}, {3.5588728879208093`*^9, 
   3.5588729064838705`*^9}, {3.5588729970730524`*^9, 
   3.5588730058405533`*^9}, {3.5588730737544384`*^9, 3.558873108737439*^9}, {
   3.558873184012745*^9, 3.558873265128384*^9}, {3.5590213231357546`*^9, 
   3.559021332855768*^9}, {3.55902162357401*^9, 3.5590216351180305`*^9}, {
   3.5590220702724223`*^9, 3.559022103449472*^9}, {3.5590222983939457`*^9, 
   3.5590224008478055`*^9}, {3.559022455663941*^9, 3.5590224832385178`*^9}, {
   3.5590225464851584`*^9, 3.559022549480364*^9}, {3.559022854269146*^9, 
   3.559022927201274*^9}, {3.5590229964507957`*^9, 3.5590230295072536`*^9}, 
   3.5590232706532526`*^9, {3.5590233315951595`*^9, 3.559023347679788*^9}, 
   3.5590234052146893`*^9, {3.5590234414535527`*^9, 3.5590234753534126`*^9}, {
   3.5590262440472193`*^9, 3.559026319413952*^9}, {3.559026385951769*^9, 
   3.5590264184164257`*^9}, {3.5590264569962935`*^9, 3.559026474312324*^9}, {
   3.5590265169959993`*^9, 3.5590265349682302`*^9}, 3.559029054641712*^9, {
   3.5590298376959653`*^9, 3.559029837773966*^9}, {3.5590320654128714`*^9, 
   3.559032095630124*^9}, 3.5590329535924044`*^9, {3.559042671616279*^9, 
   3.5590426932675176`*^9}, {3.5592872747957177`*^9, 
   3.5592872898185444`*^9}, {3.5797866127575607`*^9, 3.579786631025193*^9}, {
   3.5878971105785933`*^9, 3.587897146519644*^9}, {3.5878973082274437`*^9, 
   3.5878973161990576`*^9}, {3.58797218728496*^9, 3.5879722033373876`*^9}, {
   3.587972275048937*^9, 3.587972292864168*^9}, {3.663923193401145*^9, 
   3.663923214393346*^9}, 3.6639303896767488`*^9, {3.6648615799849195`*^9, 
   3.6648615908769355`*^9}, {3.6648695469020815`*^9, 3.664869553902091*^9}, {
   3.665122160139976*^9, 3.6651221717899923`*^9}, 3.6652191161153164`*^9, {
   3.665738335503087*^9, 3.6657383454016027`*^9}, {3.665738458209263*^9, 
   3.665738469641279*^9}, {3.665738519560851*^9, 3.6657385541008997`*^9}, {
   3.6657385911059523`*^9, 3.6657387312451496`*^9}, {3.6657388065337715`*^9, 
   3.665738807873773*^9}, 3.665738895918397*^9}],

Cell[BoxData["21.`"], "Output",
 CellChangeTimes->{{3.665738673297068*^9, 3.66573874573717*^9}, {
   3.665738808993775*^9, 3.665738814054782*^9}, 3.6657388977783995`*^9, {
   3.670039234397751*^9, 3.6700393635239415`*^9}, 3.6700485380117826`*^9, 
   3.670573633522199*^9, {3.670573670520315*^9, 3.6705737219782586`*^9}, 
   3.6705768035686483`*^9, 3.671506917582906*^9, 3.6715069503029594`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SubscriptBox["x", "1"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "2"], "\[Rule]", "1"}]},
      {
       RowBox[{
        SubscriptBox["x", "3"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "4"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "5"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "6"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "7"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "8"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "9"], "\[Rule]", "1"}]},
      {
       RowBox[{
        SubscriptBox["x", "10"], "\[Rule]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        SubscriptBox["x", "11"], "\[Rule]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        SubscriptBox["x", "12"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "13"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "14"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "15"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "16"], "\[Rule]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        SubscriptBox["x", "17"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "18"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "19"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "20"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "21"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "22"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "23"], "\[Rule]", "0"}]},
      {
       RowBox[{
        SubscriptBox["x", "24"], "\[Rule]", "0"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.665738673297068*^9, 3.66573874573717*^9}, {
   3.665738808993775*^9, 3.665738814054782*^9}, 3.6657388977783995`*^9, {
   3.670039234397751*^9, 3.6700393635239415`*^9}, 3.6700485380117826`*^9, 
   3.670573633522199*^9, {3.670573670520315*^9, 3.6705737219782586`*^9}, 
   3.6705768035686483`*^9, 3.671506917582906*^9, 3.6715069503129597`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0.0425001`6.0799348635885595"}], "}"}]], "Output",
 CellChangeTimes->{{3.665738673297068*^9, 3.66573874573717*^9}, {
   3.665738808993775*^9, 3.665738814054782*^9}, 3.6657388977783995`*^9, {
   3.670039234397751*^9, 3.6700393635239415`*^9}, 3.6700485380117826`*^9, 
   3.670573633522199*^9, {3.670573670520315*^9, 3.6705737219782586`*^9}, 
   3.6705768035686483`*^9, 3.671506917582906*^9, 3.6715069503129597`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1366, 870},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.68}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 245, 4, 80, "Title"],
Cell[CellGroupData[{
Cell[849, 30, 545, 8, 159, "Section"],
Cell[CellGroupData[{
Cell[1419, 42, 560, 16, 47, "Subsection"],
Cell[1982, 60, 2981, 44, 73, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5000, 109, 538, 7, 113, "Subsection"],
Cell[CellGroupData[{
Cell[5563, 120, 12194, 271, 786, "Input"],
Cell[17760, 393, 838, 13, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18647, 412, 348, 5, 46, "Subsection"],
Cell[CellGroupData[{
Cell[19020, 421, 1533, 35, 119, "Input"],
Cell[20556, 458, 3366, 68, 571, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23971, 532, 208, 3, 46, "Subsection"],
Cell[CellGroupData[{
Cell[24204, 539, 1620, 40, 123, "Input"],
Cell[25827, 581, 6588, 122, 52, "Output"],
Cell[32418, 705, 6588, 122, 49, "Output"],
Cell[39009, 829, 5942, 95, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45000, 930, 633, 8, 91, "Subsection"],
Cell[CellGroupData[{
Cell[45658, 942, 5572, 117, 280, "Input"],
Cell[51233, 1061, 23802, 550, 587, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75084, 1617, 837, 11, 91, "Subsection"],
Cell[CellGroupData[{
Cell[75946, 1632, 1173, 31, 73, "Input"],
Cell[77122, 1665, 22807, 592, 553, "Output"],
Cell[99932, 2259, 2130, 31, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102111, 2296, 389, 5, 46, "Subsection"],
Cell[CellGroupData[{
Cell[102525, 2305, 1064, 26, 84, "Input"],
Cell[103592, 2333, 7529, 149, 73, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111170, 2488, 464, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[111659, 2498, 1619, 41, 120, "Input"],
Cell[113281, 2541, 27032, 703, 405, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140362, 3250, 538, 8, 46, "Subsection"],
Cell[CellGroupData[{
Cell[140925, 3262, 1163, 16, 49, "Input"],
Cell[142091, 3280, 3668, 50, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145808, 3336, 723, 9, 113, "Subsection"],
Cell[CellGroupData[{
Cell[146556, 3349, 9786, 233, 658, "Input"],
Cell[156345, 3584, 394, 5, 49, "Output"],
Cell[156742, 3591, 2851, 97, 523, "Output"],
Cell[159596, 3690, 510, 9, 82, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
